/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.informed;

import aima.core.agent.Action;
import aima.core.search.framework.Metrics;
import aima.core.search.framework.Node;
import aima.core.search.framework.NodeExpander;
import aima.core.search.framework.SearchForActions;
import aima.core.search.framework.SearchUtils;
import aima.core.search.framework.evalfunc.EvaluationFunction;
import aima.core.search.framework.problem.Problem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RecursiveBestFirstSearch
implements SearchForActions {
    public static final String METRIC_NODES_EXPANDED = "nodesExpanded";
    public static final String METRIC_MAX_RECURSIVE_DEPTH = "maxRecursiveDepth";
    public static final String METRIC_PATH_COST = "pathCost";
    private static final Double INFINITY = Double.MAX_VALUE;
    private final EvaluationFunction evaluationFunction;
    private boolean avoidLoops;
    private final NodeExpander nodeExpander;
    Set<Object> explored = new HashSet<Object>();
    private Metrics metrics;

    public RecursiveBestFirstSearch(EvaluationFunction ef) {
        this(ef, false);
    }

    public RecursiveBestFirstSearch(EvaluationFunction ef, boolean avoidLoops) {
        this(ef, avoidLoops, new NodeExpander());
    }

    public RecursiveBestFirstSearch(EvaluationFunction ef, boolean avoidLoops, NodeExpander nodeExpander) {
        this.evaluationFunction = ef;
        this.avoidLoops = avoidLoops;
        this.nodeExpander = nodeExpander;
        this.metrics = new Metrics();
    }

    @Override
    public List<Action> findActions(Problem p) {
        List<Action> actions = new ArrayList<Action>();
        this.explored.clear();
        this.clearInstrumentation();
        Node n = this.nodeExpander.createRootNode(p.getInitialState());
        SearchResult sr = this.rbfs(p, n, this.evaluationFunction.f(n), INFINITY, 0);
        if (sr.hasSolution()) {
            Node s = sr.getSolutionNode();
            actions = SearchUtils.getSequenceOfActions(s);
            this.metrics.set(METRIC_PATH_COST, s.getPathCost());
        }
        return actions;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.evaluationFunction;
    }

    @Override
    public NodeExpander getNodeExpander() {
        return this.nodeExpander;
    }

    @Override
    public Metrics getMetrics() {
        this.metrics.set(METRIC_NODES_EXPANDED, this.nodeExpander.getNumOfExpandCalls());
        return this.metrics;
    }

    private void clearInstrumentation() {
        this.nodeExpander.resetCounter();
        this.metrics.set(METRIC_NODES_EXPANDED, 0);
        this.metrics.set(METRIC_MAX_RECURSIVE_DEPTH, 0);
        this.metrics.set(METRIC_PATH_COST, 0.0);
    }

    private SearchResult rbfs(Problem p, Node node, double node_f, double fLimit, int recursiveDepth) {
        SearchResult sr;
        this.updateMetrics(recursiveDepth);
        if (SearchUtils.isGoalState(p, node)) {
            return this.getResult(null, node, fLimit);
        }
        List<Node> successors = this.expandNode(node, p);
        if (successors.isEmpty()) {
            return this.getResult(node, null, INFINITY);
        }
        double[] f = new double[successors.size()];
        int size = successors.size();
        for (int s = 0; s < size; ++s) {
            f[s] = Math.max(this.evaluationFunction.f(successors.get(s)), node_f);
        }
        do {
            int bestIndex;
            if (f[bestIndex = this.getBestFValueIndex(f)] > fLimit) {
                return this.getResult(node, null, f[bestIndex]);
            }
            int altIndex = this.getNextBestFValueIndex(f, bestIndex);
            sr = this.rbfs(p, successors.get(bestIndex), f[bestIndex], Math.min(fLimit, f[altIndex]), recursiveDepth + 1);
            f[bestIndex] = sr.getFCostLimit();
        } while (!sr.hasSolution());
        return this.getResult(node, sr.getSolutionNode(), sr.getFCostLimit());
    }

    private int getBestFValueIndex(double[] f) {
        int lidx = 0;
        Double lowestSoFar = INFINITY;
        for (int i = 0; i < f.length; ++i) {
            if (!(f[i] < lowestSoFar)) continue;
            lowestSoFar = f[i];
            lidx = i;
        }
        return lidx;
    }

    private int getNextBestFValueIndex(double[] f, int bestIndex) {
        int lidx = bestIndex;
        Double lowestSoFar = INFINITY;
        for (int i = 0; i < f.length; ++i) {
            if (i == bestIndex || !(f[i] < lowestSoFar)) continue;
            lowestSoFar = f[i];
            lidx = i;
        }
        return lidx;
    }

    private List<Node> expandNode(Node node, Problem problem) {
        List<Node> result = this.nodeExpander.expand(node, problem);
        if (this.avoidLoops) {
            this.explored.add(node.getState());
            Iterator<Node> ni = result.iterator();
            while (ni.hasNext()) {
                if (!this.explored.contains(ni.next().getState())) continue;
                ni.remove();
            }
        }
        return result;
    }

    private SearchResult getResult(Node currNode, Node solutionNode, double fCostLimit) {
        if (this.avoidLoops && currNode != null) {
            this.explored.remove(currNode.getState());
        }
        return new SearchResult(solutionNode, fCostLimit);
    }

    private void updateMetrics(int recursiveDepth) {
        int maxRdepth = this.metrics.getInt(METRIC_MAX_RECURSIVE_DEPTH);
        if (recursiveDepth > maxRdepth) {
            this.metrics.set(METRIC_MAX_RECURSIVE_DEPTH, recursiveDepth);
        }
    }

    static class SearchResult {
        private Node solNode;
        private final double fCostLimit;

        public SearchResult(Node solutionNode, double fCostLimit) {
            this.solNode = solutionNode;
            this.fCostLimit = fCostLimit;
        }

        public boolean hasSolution() {
            return this.solNode != null;
        }

        public Node getSolutionNode() {
            return this.solNode;
        }

        public Double getFCostLimit() {
            return this.fCostLimit;
        }
    }
}

