/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.informed;

import aima.core.search.framework.Node;
import aima.core.search.framework.PrioritySearch;
import aima.core.search.framework.evalfunc.EvaluationFunction;
import aima.core.search.framework.qsearch.QueueSearch;
import java.util.Comparator;

public class BestFirstSearch
extends PrioritySearch {
    private final EvaluationFunction evalFunc;

    public BestFirstSearch(QueueSearch impl, EvaluationFunction ef) {
        super(impl, BestFirstSearch.createComparator(ef));
        this.evalFunc = ef;
    }

    public EvaluationFunction getEvaluationFunction() {
        return this.evalFunc;
    }

    private static Comparator<Node> createComparator(final EvaluationFunction ef) {
        return new Comparator<Node>(){

            @Override
            public int compare(Node n1, Node n2) {
                double f1 = ef.f(n1);
                double f2 = ef.f(n2);
                return Double.compare(f1, f2);
            }
        };
    }
}

