/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.framework.qsearch;

import aima.core.search.framework.Metrics;
import aima.core.search.framework.Node;
import aima.core.search.framework.NodeExpander;
import aima.core.search.framework.SearchUtils;
import aima.core.search.framework.problem.Problem;
import aima.core.util.CancelableThread;
import java.util.Queue;

public abstract class QueueSearch {
    public static final String METRIC_NODES_EXPANDED = "nodesExpanded";
    public static final String METRIC_QUEUE_SIZE = "queueSize";
    public static final String METRIC_MAX_QUEUE_SIZE = "maxQueueSize";
    public static final String METRIC_PATH_COST = "pathCost";
    protected final NodeExpander nodeExpander;
    protected Queue<Node> frontier;
    protected boolean earlyGoalTest = false;
    protected Metrics metrics = new Metrics();

    protected QueueSearch(NodeExpander nodeExpander) {
        this.nodeExpander = nodeExpander;
    }

    public Node findNode(Problem problem, Queue<Node> frontier) {
        this.frontier = frontier;
        this.clearInstrumentation();
        Node root = this.nodeExpander.createRootNode(problem.getInitialState());
        this.addToFrontier(root);
        if (this.earlyGoalTest && SearchUtils.isGoalState(problem, root)) {
            return this.getSolution(root);
        }
        while (!this.isFrontierEmpty() && !CancelableThread.currIsCanceled()) {
            Node nodeToExpand = this.removeFromFrontier();
            if (!this.earlyGoalTest && SearchUtils.isGoalState(problem, nodeToExpand)) {
                return this.getSolution(nodeToExpand);
            }
            for (Node successor : this.nodeExpander.expand(nodeToExpand, problem)) {
                this.addToFrontier(successor);
                if (!this.earlyGoalTest || !SearchUtils.isGoalState(problem, successor)) continue;
                return this.getSolution(successor);
            }
        }
        return null;
    }

    protected abstract void addToFrontier(Node var1);

    protected abstract Node removeFromFrontier();

    protected abstract boolean isFrontierEmpty();

    public void setEarlyGoalTest(boolean state) {
        this.earlyGoalTest = state;
    }

    public NodeExpander getNodeExpander() {
        return this.nodeExpander;
    }

    public Metrics getMetrics() {
        this.metrics.set(METRIC_NODES_EXPANDED, this.nodeExpander.getNumOfExpandCalls());
        return this.metrics;
    }

    public void clearInstrumentation() {
        this.nodeExpander.resetCounter();
        this.metrics.set(METRIC_NODES_EXPANDED, 0);
        this.metrics.set(METRIC_QUEUE_SIZE, 0);
        this.metrics.set(METRIC_MAX_QUEUE_SIZE, 0);
        this.metrics.set(METRIC_PATH_COST, 0);
    }

    protected void updateMetrics(int queueSize) {
        this.metrics.set(METRIC_QUEUE_SIZE, queueSize);
        int maxQSize = this.metrics.getInt(METRIC_MAX_QUEUE_SIZE);
        if (queueSize > maxQSize) {
            this.metrics.set(METRIC_MAX_QUEUE_SIZE, queueSize);
        }
    }

    private Node getSolution(Node node) {
        this.metrics.set(METRIC_PATH_COST, node.getPathCost());
        return node;
    }
}

