/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.framework.qsearch;

import aima.core.search.framework.Node;
import aima.core.search.framework.NodeExpander;
import aima.core.search.framework.problem.Problem;
import aima.core.search.framework.qsearch.QueueSearch;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;

public class GraphSearchReducedFrontier
extends QueueSearch {
    private Set<Object> explored = new HashSet<Object>();
    private Map<Object, Node> frontierNodeLookup = new HashMap<Object, Node>();
    private Comparator<? super Node> nodeComparator = null;

    public GraphSearchReducedFrontier() {
        this(new NodeExpander());
    }

    public GraphSearchReducedFrontier(NodeExpander nodeExpander) {
        super(nodeExpander);
    }

    @Override
    public Node findNode(Problem problem, Queue<Node> frontier) {
        if (frontier instanceof PriorityQueue) {
            this.nodeComparator = ((PriorityQueue)frontier).comparator();
        }
        this.explored.clear();
        this.frontierNodeLookup.clear();
        return super.findNode(problem, frontier);
    }

    public Comparator<? super Node> getNodeComparator() {
        return this.nodeComparator;
    }

    @Override
    protected void addToFrontier(Node node) {
        if (!this.explored.contains(node.getState())) {
            Node frontierNode = this.frontierNodeLookup.get(node.getState());
            if (frontierNode == null) {
                this.frontier.add(node);
                this.frontierNodeLookup.put(node.getState(), node);
                this.updateMetrics(this.frontier.size());
            } else if (this.nodeComparator != null && this.nodeComparator.compare(node, frontierNode) < 0) {
                if (this.frontier.remove(frontierNode)) {
                    this.frontierNodeLookup.remove(frontierNode.getState());
                }
                this.frontier.add(node);
                this.frontierNodeLookup.put(node.getState(), node);
            }
        }
    }

    @Override
    protected Node removeFromFrontier() {
        Node result = (Node)this.frontier.remove();
        this.frontierNodeLookup.remove(result.getState());
        this.explored.add(result.getState());
        this.updateMetrics(this.frontier.size());
        return result;
    }

    @Override
    protected boolean isFrontierEmpty() {
        return this.frontier.isEmpty();
    }
}

