/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.framework.qsearch;

import aima.core.search.framework.Node;
import aima.core.search.framework.NodeExpander;
import aima.core.search.framework.problem.Problem;
import aima.core.search.framework.qsearch.QueueSearch;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;

public class GraphSearchBFS
extends QueueSearch {
    private Set<Object> explored = new HashSet<Object>();
    private Set<Object> frontierStates = new HashSet<Object>();

    public GraphSearchBFS() {
        this(new NodeExpander());
    }

    public GraphSearchBFS(NodeExpander nodeExpander) {
        super(nodeExpander);
    }

    @Override
    public Node findNode(Problem problem, Queue<Node> frontier) {
        this.explored.clear();
        this.frontierStates.clear();
        return super.findNode(problem, frontier);
    }

    @Override
    protected void addToFrontier(Node node) {
        if (!this.explored.contains(node.getState()) && !this.frontierStates.contains(node.getState())) {
            this.frontier.add(node);
            this.frontierStates.add(node.getState());
            this.updateMetrics(this.frontier.size());
        }
    }

    @Override
    protected Node removeFromFrontier() {
        Node result = (Node)this.frontier.remove();
        this.explored.add(result.getState());
        this.frontierStates.remove(result.getState());
        this.updateMetrics(this.frontier.size());
        return result;
    }

    @Override
    protected boolean isFrontierEmpty() {
        return this.frontier.isEmpty();
    }
}

