/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.framework.qsearch;

import aima.core.search.framework.Node;
import aima.core.search.framework.NodeExpander;
import aima.core.search.framework.problem.Problem;
import aima.core.search.framework.qsearch.QueueSearch;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;

public class GraphSearch
extends QueueSearch {
    private Set<Object> explored = new HashSet<Object>();

    public GraphSearch() {
        this(new NodeExpander());
    }

    public GraphSearch(NodeExpander nodeExpander) {
        super(nodeExpander);
    }

    @Override
    public Node findNode(Problem problem, Queue<Node> frontier) {
        this.explored.clear();
        return super.findNode(problem, frontier);
    }

    @Override
    protected void addToFrontier(Node node) {
        if (!this.explored.contains(node.getState())) {
            this.frontier.add(node);
            this.updateMetrics(this.frontier.size());
        }
    }

    @Override
    protected Node removeFromFrontier() {
        this.cleanUpFrontier();
        Node result = (Node)this.frontier.remove();
        this.explored.add(result.getState());
        this.updateMetrics(this.frontier.size());
        return result;
    }

    @Override
    protected boolean isFrontierEmpty() {
        this.cleanUpFrontier();
        this.updateMetrics(this.frontier.size());
        return this.frontier.isEmpty();
    }

    private void cleanUpFrontier() {
        while (!this.frontier.isEmpty() && this.explored.contains(((Node)this.frontier.element()).getState())) {
            this.frontier.remove();
        }
    }
}

