/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.framework.qsearch;

import aima.core.agent.Action;
import aima.core.search.framework.Node;
import aima.core.search.framework.NodeExpander;
import aima.core.search.framework.problem.BidirectionalProblem;
import aima.core.search.framework.problem.Problem;
import aima.core.search.framework.qsearch.QueueSearch;
import aima.core.util.CancelableThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class BidirectionalSearch
extends QueueSearch {
    private static final int ORG_P_IDX = 0;
    private static final int REV_P_IDX = 1;
    private boolean isReverseActionTestEnabled = true;
    private List<Map<Object, ExtendedNode>> explored = new ArrayList<Map<Object, ExtendedNode>>(2);
    private ExtendedNode goalStateNode;

    public BidirectionalSearch() {
        this(new NodeExpander());
    }

    public BidirectionalSearch(NodeExpander nodeExpander) {
        super(nodeExpander);
        this.explored.add(new HashMap());
        this.explored.add(new HashMap());
    }

    @Override
    public Node findNode(Problem problem, Queue<Node> frontier) {
        assert (problem instanceof BidirectionalProblem);
        this.nodeExpander.useParentLinks(true);
        this.frontier = frontier;
        this.clearInstrumentation();
        this.explored.get(0).clear();
        this.explored.get(1).clear();
        Problem orgP = ((BidirectionalProblem)((Object)problem)).getOriginalProblem();
        Problem revP = ((BidirectionalProblem)((Object)problem)).getReverseProblem();
        ExtendedNode initStateNode = new ExtendedNode(this.nodeExpander.createRootNode(orgP.getInitialState()), 0);
        this.goalStateNode = new ExtendedNode(this.nodeExpander.createRootNode(revP.getInitialState()), 1);
        if (orgP.getInitialState().equals(revP.getInitialState())) {
            return this.getSolution(orgP, initStateNode, this.goalStateNode);
        }
        this.addToFrontier(initStateNode);
        this.addToFrontier(this.goalStateNode);
        while (!this.isFrontierEmpty() && !CancelableThread.currIsCanceled()) {
            ExtendedNode nodeFromOtherProblem;
            ExtendedNode nodeToExpand = (ExtendedNode)this.removeFromFrontier();
            if (!this.earlyGoalTest && (nodeFromOtherProblem = this.getCorrespondingNodeFromOtherProblem(nodeToExpand)) != null) {
                return this.getSolution(orgP, nodeToExpand, nodeFromOtherProblem);
            }
            for (Node s : this.nodeExpander.expand(nodeToExpand, problem)) {
                ExtendedNode successor = new ExtendedNode(s, nodeToExpand.getProblemIndex());
                if (this.isReverseActionTestEnabled && nodeToExpand.getProblemIndex() != 0 && this.getReverseAction(orgP, successor) == null) continue;
                if (this.earlyGoalTest && (nodeFromOtherProblem = this.getCorrespondingNodeFromOtherProblem(successor)) != null) {
                    return this.getSolution(orgP, successor, nodeFromOtherProblem);
                }
                this.addToFrontier(successor);
            }
        }
        return null;
    }

    public void setReverseActionTestEnabled(boolean state) {
        this.isReverseActionTestEnabled = state;
    }

    @Override
    protected void addToFrontier(Node node) {
        if (!this.isExplored(node)) {
            this.frontier.add(node);
            this.updateMetrics(this.frontier.size());
        }
    }

    @Override
    protected Node removeFromFrontier() {
        this.cleanUpFrontier();
        Node result = (Node)this.frontier.remove();
        this.updateMetrics(this.frontier.size());
        this.setExplored(result);
        return result;
    }

    @Override
    protected boolean isFrontierEmpty() {
        this.cleanUpFrontier();
        this.updateMetrics(this.frontier.size());
        return this.frontier.isEmpty();
    }

    private void cleanUpFrontier() {
        while (!this.frontier.isEmpty() && this.isExplored((Node)this.frontier.element())) {
            this.frontier.remove();
        }
    }

    private Node getSolution(Problem orgP, ExtendedNode node1, ExtendedNode node2) {
        Node revNode;
        assert (node1.getState().equals(node2.getState()));
        Node orgNode = node1.getProblemIndex() == 0 ? node1 : node2;
        ExtendedNode extendedNode = revNode = node1.getProblemIndex() == 1 ? node1 : node2;
        while (revNode.getParent() != null) {
            Action action = this.getReverseAction(orgP, revNode);
            if (action != null) {
                Object nextState = revNode.getParent().getState();
                double stepCosts = orgP.getStepCostFunction().c(revNode.getState(), action, nextState);
                orgNode = this.nodeExpander.createNode(nextState, orgNode, action, stepCosts);
                revNode = revNode.getParent();
                continue;
            }
            return null;
        }
        this.metrics.set("pathCost", orgNode.getPathCost());
        return orgNode;
    }

    private Action getReverseAction(Problem orgP, Node node) {
        Object currState = node.getState();
        Object nextState = node.getParent().getState();
        for (Action action : orgP.getActionsFunction().actions(currState)) {
            Object aResult = orgP.getResultFunction().result(currState, action);
            if (!nextState.equals(aResult)) continue;
            return action;
        }
        return null;
    }

    private boolean isExplored(Node node) {
        ExtendedNode eNode = (ExtendedNode)node;
        return this.explored.get(eNode.getProblemIndex()).containsKey(eNode.getState());
    }

    private void setExplored(Node node) {
        ExtendedNode eNode = (ExtendedNode)node;
        this.explored.get(eNode.getProblemIndex()).put(eNode.getState(), eNode);
    }

    private ExtendedNode getCorrespondingNodeFromOtherProblem(ExtendedNode node) {
        ExtendedNode result = this.explored.get(1 - node.getProblemIndex()).get(node.getState());
        if (result == null && node.getProblemIndex() == 0 && node.getState() == this.goalStateNode.getState()) {
            result = this.goalStateNode;
        }
        return result;
    }

    static class ExtendedNode
    extends Node {
        int problemIndex;

        public ExtendedNode(Node node, int problemIndex) {
            super(node.getState(), node.getParent(), node.getAction(), node.getPathCost());
            this.problemIndex = problemIndex;
        }

        public int getProblemIndex() {
            return this.problemIndex;
        }

        @Override
        public String toString() {
            return "[" + this.getState() + ":" + this.problemIndex + "]";
        }
    }
}

