/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.framework;

import aima.core.agent.Action;
import aima.core.agent.Percept;
import aima.core.agent.State;
import aima.core.agent.impl.AbstractAgent;
import aima.core.agent.impl.NoOpAction;
import aima.core.search.framework.problem.Problem;
import aima.core.util.Util;
import java.util.ArrayList;
import java.util.List;

public abstract class SimpleProblemSolvingAgent
extends AbstractAgent {
    private List<Action> seq = new ArrayList<Action>();
    private boolean formulateGoalsIndefinitely = true;
    private int maxGoalsToFormulate = 1;
    private int goalsFormulated = 0;

    public SimpleProblemSolvingAgent() {
        this.formulateGoalsIndefinitely = true;
    }

    public SimpleProblemSolvingAgent(int maxGoalsToFormulate) {
        this.formulateGoalsIndefinitely = false;
        this.maxGoalsToFormulate = maxGoalsToFormulate;
    }

    @Override
    public Action execute(Percept p) {
        Action action = NoOpAction.NO_OP;
        this.updateState(p);
        if (0 == this.seq.size()) {
            if (this.formulateGoalsIndefinitely || this.goalsFormulated < this.maxGoalsToFormulate) {
                if (this.goalsFormulated > 0) {
                    this.notifyViewOfMetrics();
                }
                Object goal = this.formulateGoal();
                ++this.goalsFormulated;
                Problem problem = this.formulateProblem(goal);
                this.seq.addAll(this.search(problem));
                if (0 == this.seq.size()) {
                    this.seq.add(NoOpAction.NO_OP);
                }
            } else {
                this.setAlive(false);
                this.notifyViewOfMetrics();
            }
        }
        if (this.seq.size() > 0) {
            action = Util.first(this.seq);
            this.seq = Util.rest(this.seq);
        }
        return action;
    }

    protected abstract State updateState(Percept var1);

    protected abstract Object formulateGoal();

    protected abstract Problem formulateProblem(Object var1);

    protected abstract List<Action> search(Problem var1);

    protected abstract void notifyViewOfMetrics();
}

