/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.framework;

import aima.core.agent.Action;
import aima.core.agent.impl.NoOpAction;
import aima.core.search.framework.Node;
import aima.core.search.framework.SolutionChecker;
import aima.core.search.framework.evalfunc.HeuristicFunction;
import aima.core.search.framework.problem.GoalTest;
import aima.core.search.framework.problem.Problem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SearchUtils {
    public static List<Action> getSequenceOfActions(Node node) {
        List<Node> nodes = node.getPathFromRoot();
        ArrayList<Action> actions = new ArrayList<Action>();
        if (nodes.size() == 1) {
            actions.add(NoOpAction.NO_OP);
        } else {
            for (int i = 1; i < nodes.size(); ++i) {
                actions.add(nodes.get(i).getAction());
            }
        }
        return actions;
    }

    public static List<Action> failure() {
        return Collections.emptyList();
    }

    public static boolean isFailure(List<Action> actions) {
        return actions.isEmpty();
    }

    public static boolean isGoalState(Problem p, Node n) {
        boolean isGoal = false;
        GoalTest gt = p.getGoalTest();
        if (gt.isGoalState(n.getState())) {
            isGoal = gt instanceof SolutionChecker ? ((SolutionChecker)gt).isAcceptableSolution(SearchUtils.getSequenceOfActions(n), n.getState()) : true;
        }
        return isGoal;
    }

    public static HeuristicFunction getZeroHeuristic() {
        return new HeuristicFunction(){

            @Override
            public double h(Object state) {
                return 0.0;
            }
        };
    }
}

