/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.framework;

import aima.core.agent.Action;
import aima.core.agent.Percept;
import aima.core.agent.impl.AbstractAgent;
import aima.core.agent.impl.NoOpAction;
import aima.core.search.framework.Metrics;
import aima.core.search.framework.SearchForActions;
import aima.core.search.framework.problem.Problem;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class SearchAgent
extends AbstractAgent {
    protected List<Action> actionList;
    private Iterator<Action> actionIterator;
    private Metrics searchMetrics;

    public SearchAgent(Problem p, SearchForActions search) throws Exception {
        this.actionList = search.findActions(p);
        this.actionIterator = this.actionList.iterator();
        this.searchMetrics = search.getMetrics();
    }

    @Override
    public Action execute(Percept p) {
        if (this.actionIterator.hasNext()) {
            return this.actionIterator.next();
        }
        return NoOpAction.NO_OP;
    }

    public boolean isDone() {
        return !this.actionIterator.hasNext();
    }

    public List<Action> getActions() {
        return this.actionList;
    }

    public Properties getInstrumentation() {
        Properties retVal = new Properties();
        for (String key : this.searchMetrics.keySet()) {
            String value = this.searchMetrics.get(key);
            retVal.setProperty(key, value);
        }
        return retVal;
    }
}

