/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.framework;

import aima.core.agent.Action;
import aima.core.agent.Percept;
import aima.core.agent.impl.AbstractAgent;
import aima.core.agent.impl.NoOpAction;
import aima.core.search.framework.problem.Problem;
import aima.core.util.Util;
import java.util.ArrayList;
import java.util.List;

public abstract class ProblemSolvingAgent
extends AbstractAgent {
    protected List<Action> plan = new ArrayList<Action>();

    @Override
    public Action execute(Percept p) {
        this.updateState(p);
        while (this.plan.isEmpty()) {
            Object goal = this.formulateGoal();
            if (goal != null) {
                Problem problem = this.formulateProblem(goal);
                this.plan.addAll(this.search(problem));
                if (!this.plan.isEmpty() || this.tryWithAnotherGoal()) continue;
                this.plan.add(NoOpAction.NO_OP);
                this.setAlive(false);
                continue;
            }
            this.plan.add(NoOpAction.NO_OP);
            this.setAlive(false);
        }
        Action action = Util.first(this.plan);
        this.plan = Util.rest(this.plan);
        return action;
    }

    protected boolean tryWithAnotherGoal() {
        return false;
    }

    protected abstract Object updateState(Percept var1);

    protected abstract Object formulateGoal();

    protected abstract Problem formulateProblem(Object var1);

    protected abstract List<Action> search(Problem var1);
}

