/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.framework;

import aima.core.agent.Action;
import aima.core.search.framework.Metrics;
import aima.core.search.framework.Node;
import aima.core.search.framework.NodeExpander;
import aima.core.search.framework.QueueFactory;
import aima.core.search.framework.SearchForActions;
import aima.core.search.framework.SearchForStates;
import aima.core.search.framework.SearchUtils;
import aima.core.search.framework.problem.Problem;
import aima.core.search.framework.qsearch.QueueSearch;
import java.util.Comparator;
import java.util.List;

public class PrioritySearch
implements SearchForActions,
SearchForStates {
    private final QueueSearch implementation;
    private final Comparator<Node> comparator;

    public PrioritySearch(QueueSearch impl, Comparator<Node> comp) {
        this.implementation = impl;
        this.comparator = comp;
    }

    @Override
    public List<Action> findActions(Problem p) {
        this.implementation.getNodeExpander().useParentLinks(true);
        Node node = this.implementation.findNode(p, QueueFactory.createPriorityQueue(this.comparator));
        return node == null ? SearchUtils.failure() : SearchUtils.getSequenceOfActions(node);
    }

    @Override
    public Object findState(Problem p) {
        this.implementation.getNodeExpander().useParentLinks(false);
        Node node = this.implementation.findNode(p, QueueFactory.createPriorityQueue(this.comparator));
        return node == null ? null : node.getState();
    }

    public Comparator<Node> getComparator() {
        return this.comparator;
    }

    @Override
    public NodeExpander getNodeExpander() {
        return this.implementation.getNodeExpander();
    }

    @Override
    public Metrics getMetrics() {
        return this.implementation.getMetrics();
    }
}

