/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.framework;

import aima.core.agent.Action;
import aima.core.search.framework.Node;
import aima.core.search.framework.problem.ActionsFunction;
import aima.core.search.framework.problem.Problem;
import aima.core.search.framework.problem.ResultFunction;
import aima.core.search.framework.problem.StepCostFunction;
import java.util.ArrayList;
import java.util.List;

public class NodeExpander {
    protected boolean useParentLinks = true;
    private List<NodeListener> nodeListeners = new ArrayList<NodeListener>();
    protected int counter;

    public NodeExpander useParentLinks(boolean state) {
        this.useParentLinks = state;
        return this;
    }

    public Node createRootNode(Object state) {
        return new Node(state);
    }

    public Node createNode(Object state, Node parent, Action action, double stepCost) {
        Node p = this.useParentLinks ? parent : null;
        return new Node(state, p, action, parent.getPathCost() + stepCost);
    }

    public List<Node> expand(Node node, Problem problem) {
        ArrayList<Node> successors = new ArrayList<Node>();
        ActionsFunction actionsFunction = problem.getActionsFunction();
        ResultFunction resultFunction = problem.getResultFunction();
        StepCostFunction stepCostFunction = problem.getStepCostFunction();
        for (Action action : actionsFunction.actions(node.getState())) {
            Object successorState = resultFunction.result(node.getState(), action);
            double stepCost = stepCostFunction.c(node.getState(), action, successorState);
            successors.add(this.createNode(successorState, node, action, stepCost));
        }
        this.notifyNodeListeners(node);
        ++this.counter;
        return successors;
    }

    public void addNodeListener(NodeListener listener) {
        this.nodeListeners.add(listener);
    }

    protected void notifyNodeListeners(Node node) {
        for (NodeListener listener : this.nodeListeners) {
            listener.onNodeExpanded(node);
        }
    }

    public void resetCounter() {
        this.counter = 0;
    }

    public int getNumOfExpandCalls() {
        return this.counter;
    }

    public static interface NodeListener {
        public void onNodeExpanded(Node var1);
    }
}

