/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.framework;

import aima.core.agent.Action;
import java.util.ArrayList;
import java.util.List;

public class Node {
    private Object state;
    private Node parent;
    private Action action;
    private double pathCost;

    public Node(Object state) {
        this.state = state;
        this.pathCost = 0.0;
    }

    public Node(Object state, Node parent, Action action, double pathCost) {
        this(state);
        this.parent = parent;
        this.action = action;
        this.pathCost = pathCost;
    }

    public Object getState() {
        return this.state;
    }

    public Node getParent() {
        return this.parent;
    }

    public Action getAction() {
        return this.action;
    }

    public double getPathCost() {
        return this.pathCost;
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public List<Node> getPathFromRoot() {
        ArrayList<Node> path = new ArrayList<Node>();
        Node current = this;
        while (!current.isRootNode()) {
            path.add(0, current);
            current = current.getParent();
        }
        path.add(0, current);
        return path;
    }

    public String toString() {
        return "[parent=" + this.parent + ", action=" + this.action + ", state=" + this.getState() + ", pathCost=" + this.pathCost + "]";
    }
}

