/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.csp.examples;

import aima.core.search.csp.Assignment;
import aima.core.search.csp.Constraint;
import aima.core.search.csp.Variable;
import java.util.ArrayList;
import java.util.List;

public class DiffNotEqualConstraint
implements Constraint {
    private Variable var1;
    private Variable var2;
    private int diff;
    private List<Variable> scope;

    public DiffNotEqualConstraint(Variable var1, Variable var2, int diff) {
        this.var1 = var1;
        this.var2 = var2;
        this.diff = diff;
        this.scope = new ArrayList<Variable>(2);
        this.scope.add(var1);
        this.scope.add(var2);
    }

    @Override
    public List<Variable> getScope() {
        return this.scope;
    }

    @Override
    public boolean isSatisfiedWith(Assignment assignment) {
        Object value1 = assignment.getAssignment(this.var1);
        Object value2 = assignment.getAssignment(this.var2);
        return value1 == null || value2 == null || value1 instanceof Integer && value2 instanceof Integer && Math.abs((Integer)value1 - (Integer)value2) != this.diff;
    }
}

