/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.csp;

import aima.core.search.csp.Assignment;
import aima.core.search.csp.CSP;
import aima.core.search.csp.Constraint;
import aima.core.search.csp.DomainRestoreInfo;
import aima.core.search.csp.SolutionStrategy;
import aima.core.search.csp.Variable;
import aima.core.util.Util;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TreeCSPSolver
extends SolutionStrategy {
    protected int[] parent;

    @Override
    public Assignment solve(CSP csp) {
        Assignment assignment = new Assignment();
        List<Variable> l = csp.getVariables();
        int n = l.size();
        Variable root = Util.selectRandomlyFromList(l);
        l = this.topologicalSort(csp, l, root);
        DomainRestoreInfo info = new DomainRestoreInfo();
        for (int i = n - 1; i >= 1; --i) {
            Variable var = l.get(i);
            for (Constraint constraint : csp.getConstraints(var)) {
                if (constraint.getScope().size() != 2 || csp.getNeighbor(var, constraint) != l.get(this.parent[i]) || !this.makeArcConsistent(l.get(this.parent[i]), var, constraint, csp, info) || !csp.getDomain(l.get(this.parent[i])).isEmpty()) continue;
                info.setEmptyDomainFound(true);
                assignment = null;
                return assignment;
            }
        }
        boolean assignment_consistent = false;
        for (int i = 0; i < n; ++i) {
            Variable var = l.get(i);
            assignment_consistent = false;
            for (Object value : csp.getDomain(var)) {
                assignment.setAssignment(var, value);
                if (!assignment.isConsistent(csp.getConstraints(var))) continue;
                assignment_consistent = true;
                break;
            }
            if (assignment_consistent) continue;
            assignment = null;
            return assignment;
        }
        return assignment;
    }

    protected List<Variable> topologicalSort(CSP csp, List<Variable> l, Variable root) {
        this.parent = new int[l.size()];
        ArrayList<Variable> result = new ArrayList<Variable>();
        LinkedList<Variable> q = new LinkedList<Variable>();
        int i = 1;
        int parent_index = 0;
        int node_count = 0;
        q.add(root);
        while (!q.isEmpty()) {
            node_count = q.size();
            while (node_count > 0) {
                Variable var = (Variable)q.remove();
                result.add(var);
                for (Constraint constraint : csp.getConstraints(var)) {
                    Variable neighbour = csp.getNeighbor(var, constraint);
                    if (result.contains(neighbour)) continue;
                    this.parent[i] = parent_index;
                    ++i;
                    q.add(neighbour);
                }
                --node_count;
                ++parent_index;
            }
        }
        return result;
    }

    protected boolean makeArcConsistent(Variable xi, Variable xj, Constraint constraint, CSP csp, DomainRestoreInfo info) {
        boolean revised = false;
        Assignment assignment = new Assignment();
        for (Object iValue : csp.getDomain(xi)) {
            assignment.setAssignment(xi, iValue);
            boolean consistentExtensionFound = false;
            for (Object jValue : csp.getDomain(xj)) {
                assignment.setAssignment(xj, jValue);
                if (!constraint.isSatisfiedWith(assignment)) continue;
                consistentExtensionFound = true;
                break;
            }
            if (consistentExtensionFound) continue;
            info.storeDomainFor(xi, csp.getDomain(xi));
            csp.removeValueFromDomain(xi, iValue);
            revised = true;
        }
        return revised;
    }
}

