/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.csp;

import aima.core.search.csp.Assignment;
import aima.core.search.csp.CSP;
import aima.core.search.csp.CSPStateListener;
import java.util.ArrayList;
import java.util.List;

public abstract class SolutionStrategy {
    List<CSPStateListener> listeners = new ArrayList<CSPStateListener>();

    public void addCSPStateListener(CSPStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeCSPStateListener(CSPStateListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireStateChanged(CSP csp) {
        for (CSPStateListener listener : this.listeners) {
            listener.stateChanged(csp.copyDomains());
        }
    }

    protected void fireStateChanged(Assignment assignment, CSP csp) {
        for (CSPStateListener listener : this.listeners) {
            listener.stateChanged(assignment.copy(), csp.copyDomains());
        }
    }

    public abstract Assignment solve(CSP var1);
}

