/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.csp;

import aima.core.search.csp.Assignment;
import aima.core.search.csp.CSP;
import aima.core.search.csp.Constraint;
import aima.core.search.csp.SolutionStrategy;
import aima.core.search.csp.Variable;
import aima.core.util.Util;
import java.util.ArrayList;
import java.util.List;

public class MinConflictsStrategy
extends SolutionStrategy {
    private int maxSteps;

    public MinConflictsStrategy(int maxSteps) {
        this.maxSteps = maxSteps;
    }

    @Override
    public Assignment solve(CSP csp) {
        Assignment assignment = this.generateRandomAssignment(csp);
        this.fireStateChanged(assignment, csp);
        for (int i = 0; i < this.maxSteps; ++i) {
            if (assignment.isSolution(csp)) {
                return assignment;
            }
            List<Variable> vars = this.getConflictedVariables(assignment, csp);
            Variable var = Util.selectRandomlyFromList(vars);
            Object value = this.getMinConflictValueFor(var, assignment, csp);
            assignment.setAssignment(var, value);
            this.fireStateChanged(assignment, csp);
        }
        return null;
    }

    private Assignment generateRandomAssignment(CSP csp) {
        Assignment assignment = new Assignment();
        for (Variable var : csp.getVariables()) {
            Object randomValue = Util.selectRandomlyFromList(csp.getDomain(var).asList());
            assignment.setAssignment(var, randomValue);
        }
        return assignment;
    }

    private List<Variable> getConflictedVariables(Assignment assignment, CSP csp) {
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Constraint constraint : csp.getConstraints()) {
            if (constraint.isSatisfiedWith(assignment)) continue;
            for (Variable var : constraint.getScope()) {
                if (result.contains(var)) continue;
                result.add(var);
            }
        }
        return result;
    }

    private Object getMinConflictValueFor(Variable var, Assignment assignment, CSP csp) {
        List<Constraint> constraints = csp.getConstraints(var);
        Assignment duplicate = assignment.copy();
        int minConflict = Integer.MAX_VALUE;
        ArrayList<Object> resultCandidates = new ArrayList<Object>();
        for (Object value : csp.getDomain(var)) {
            duplicate.setAssignment(var, value);
            int currConflict = this.countConflicts(duplicate, constraints);
            if (currConflict > minConflict) continue;
            if (currConflict < minConflict) {
                resultCandidates.clear();
                minConflict = currConflict;
            }
            resultCandidates.add(value);
        }
        if (!resultCandidates.isEmpty()) {
            return Util.selectRandomlyFromList(resultCandidates);
        }
        return null;
    }

    private int countConflicts(Assignment assignment, List<Constraint> constraints) {
        int result = 0;
        for (Constraint constraint : constraints) {
            if (constraint.isSatisfiedWith(assignment)) continue;
            ++result;
        }
        return result;
    }
}

