/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.csp;

import aima.core.search.csp.AC3Strategy;
import aima.core.search.csp.Assignment;
import aima.core.search.csp.BacktrackingStrategy;
import aima.core.search.csp.CSP;
import aima.core.search.csp.Constraint;
import aima.core.search.csp.DomainRestoreInfo;
import aima.core.search.csp.Variable;
import aima.core.util.datastructure.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ImprovedBacktrackingStrategy
extends BacktrackingStrategy {
    protected Selection selectionStrategy = Selection.DEFAULT_ORDER;
    protected Inference inferenceStrategy = Inference.NONE;
    protected boolean isLCVHeuristicEnabled;

    public ImprovedBacktrackingStrategy() {
    }

    public ImprovedBacktrackingStrategy(boolean enableMRV, boolean enableDeg, boolean enableAC3, boolean enableLCV) {
        if (enableMRV) {
            this.setVariableSelection(enableDeg ? Selection.MRV_DEG : Selection.MRV);
        }
        if (enableAC3) {
            this.setInference(Inference.AC3);
        }
        this.enableLCV(enableLCV);
    }

    public void setVariableSelection(Selection sStrategy) {
        this.selectionStrategy = sStrategy;
    }

    public void setInference(Inference iStrategy) {
        this.inferenceStrategy = iStrategy;
    }

    public void enableLCV(boolean state) {
        this.isLCVHeuristicEnabled = state;
    }

    @Override
    public Assignment solve(CSP csp) {
        DomainRestoreInfo info;
        if (this.inferenceStrategy == Inference.AC3 && !(info = new AC3Strategy().reduceDomains(csp)).isEmpty()) {
            this.fireStateChanged(csp);
            if (info.isEmptyDomainFound()) {
                return null;
            }
        }
        return super.solve(csp);
    }

    @Override
    protected Variable selectUnassignedVariable(Assignment assignment, CSP csp) {
        switch (this.selectionStrategy) {
            case MRV: {
                return this.applyMRVHeuristic(csp, assignment).get(0);
            }
            case MRV_DEG: {
                List<Variable> vars = this.applyMRVHeuristic(csp, assignment);
                return this.applyDegreeHeuristic(vars, assignment, csp).get(0);
            }
        }
        for (Variable var : csp.getVariables()) {
            if (assignment.hasAssignmentFor(var)) continue;
            return var;
        }
        return null;
    }

    @Override
    protected Iterable<?> orderDomainValues(Variable var, Assignment assignment, CSP csp) {
        if (!this.isLCVHeuristicEnabled) {
            return csp.getDomain(var);
        }
        return this.applyLeastConstrainingValueHeuristic(var, csp);
    }

    @Override
    protected DomainRestoreInfo inference(Variable var, Assignment assignment, CSP csp) {
        switch (this.inferenceStrategy) {
            case FORWARD_CHECKING: {
                return this.doForwardChecking(var, assignment, csp);
            }
            case AC3: {
                return new AC3Strategy().reduceDomains(var, assignment.getAssignment(var), csp);
            }
        }
        return new DomainRestoreInfo().compactify();
    }

    private List<Variable> applyMRVHeuristic(CSP csp, Assignment assignment) {
        ArrayList<Variable> result = new ArrayList<Variable>();
        int mrv = Integer.MAX_VALUE;
        for (Variable var : csp.getVariables()) {
            int num;
            if (assignment.hasAssignmentFor(var) || (num = csp.getDomain(var).size()) > mrv) continue;
            if (num < mrv) {
                result.clear();
                mrv = num;
            }
            result.add(var);
        }
        return result;
    }

    private List<Variable> applyDegreeHeuristic(List<Variable> vars, Assignment assignment, CSP csp) {
        ArrayList<Variable> result = new ArrayList<Variable>();
        int maxDegree = Integer.MIN_VALUE;
        for (Variable var : vars) {
            int degree = 0;
            for (Constraint constraint : csp.getConstraints(var)) {
                Variable neighbor = csp.getNeighbor(var, constraint);
                if (assignment.hasAssignmentFor(neighbor) || csp.getDomain(neighbor).size() <= 1) continue;
                ++degree;
            }
            if (degree < maxDegree) continue;
            if (degree > maxDegree) {
                result.clear();
                maxDegree = degree;
            }
            result.add(var);
        }
        return result;
    }

    private List<Object> applyLeastConstrainingValueHeuristic(Variable var, CSP csp) {
        ArrayList<Pair<Object, Integer>> pairs = new ArrayList<Pair<Object, Integer>>();
        for (Object value : csp.getDomain(var)) {
            int n = this.countLostValues(var, value, csp);
            pairs.add(new Pair<Object, Integer>(value, n));
        }
        Collections.sort(pairs, new Comparator<Pair<Object, Integer>>(){

            @Override
            public int compare(Pair<Object, Integer> o1, Pair<Object, Integer> o2) {
                return o1.getSecond() < o2.getSecond() ? -1 : (o1.getSecond() > o2.getSecond() ? 1 : 0);
            }
        });
        ArrayList<Object> result = new ArrayList<Object>();
        for (Pair pair : pairs) {
            result.add(pair.getFirst());
        }
        return result;
    }

    private int countLostValues(Variable var, Object value, CSP csp) {
        int result = 0;
        Assignment assignment = new Assignment();
        assignment.setAssignment(var, value);
        for (Constraint constraint : csp.getConstraints(var)) {
            Variable neighbor = csp.getNeighbor(var, constraint);
            for (Object nValue : csp.getDomain(neighbor)) {
                assignment.setAssignment(neighbor, nValue);
                if (constraint.isSatisfiedWith(assignment)) continue;
                ++result;
            }
        }
        return result;
    }

    private DomainRestoreInfo doForwardChecking(Variable var, Assignment assignment, CSP csp) {
        DomainRestoreInfo result = new DomainRestoreInfo();
        for (Constraint constraint : csp.getConstraints(var)) {
            List<Variable> scope = constraint.getScope();
            if (scope.size() != 2) continue;
            for (Variable neighbor : constraint.getScope()) {
                if (assignment.hasAssignmentFor(neighbor) || !this.revise(neighbor, constraint, assignment, csp, result) || !csp.getDomain(neighbor).isEmpty()) continue;
                result.setEmptyDomainFound(true);
                return result;
            }
        }
        return result;
    }

    private boolean revise(Variable var, Constraint constraint, Assignment assignment, CSP csp, DomainRestoreInfo info) {
        boolean revised = false;
        for (Object value : csp.getDomain(var)) {
            assignment.setAssignment(var, value);
            if (!constraint.isSatisfiedWith(assignment)) {
                info.storeDomainFor(var, csp.getDomain(var));
                csp.removeValueFromDomain(var, value);
                revised = true;
            }
            assignment.removeAssignment(var);
        }
        return revised;
    }

    public static enum Inference {
        NONE,
        FORWARD_CHECKING,
        AC3;

    }

    public static enum Selection {
        DEFAULT_ORDER,
        MRV,
        MRV_DEG;

    }
}

