/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.csp;

import aima.core.search.csp.CSP;
import aima.core.search.csp.Domain;
import aima.core.search.csp.Variable;
import aima.core.util.datastructure.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DomainRestoreInfo {
    private List<Pair<Variable, Domain>> savedDomains = new ArrayList<Pair<Variable, Domain>>();
    private HashSet<Variable> affectedVariables = new HashSet();
    private boolean emptyDomainObserved;

    public void clear() {
        this.savedDomains.clear();
        this.affectedVariables.clear();
    }

    public boolean isEmpty() {
        return this.savedDomains.isEmpty();
    }

    public void storeDomainFor(Variable var, Domain domain) {
        if (!this.affectedVariables.contains(var)) {
            this.savedDomains.add(new Pair<Variable, Domain>(var, domain));
            this.affectedVariables.add(var);
        }
    }

    public void setEmptyDomainFound(boolean b) {
        this.emptyDomainObserved = b;
    }

    public DomainRestoreInfo compactify() {
        this.affectedVariables = null;
        return this;
    }

    public boolean isEmptyDomainFound() {
        return this.emptyDomainObserved;
    }

    public List<Pair<Variable, Domain>> getSavedDomains() {
        return this.savedDomains;
    }

    public void restoreDomains(CSP csp) {
        for (Pair<Variable, Domain> pair : this.getSavedDomains()) {
            csp.setDomain(pair.getFirst(), pair.getSecond());
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (Pair<Variable, Domain> pair : this.savedDomains) {
            result.append(pair.getFirst() + "=" + pair.getSecond() + " ");
        }
        if (this.emptyDomainObserved) {
            result.append("!");
        }
        return result.toString();
    }
}

