/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.csp;

import aima.core.util.ArrayIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Domain
implements Iterable<Object> {
    private Object[] values;

    public Domain(List<?> values) {
        this.values = new Object[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            this.values[i] = values.get(i);
        }
    }

    public Domain(Object[] values) {
        this.values = new Object[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.values[i] = values[i];
        }
    }

    public int size() {
        return this.values.length;
    }

    public Object get(int index) {
        return this.values[index];
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public boolean contains(Object value) {
        for (Object v : this.values) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Object> iterator() {
        return new ArrayIterator<Object>(this.values);
    }

    public List<Object> asList() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : this.values) {
            result.add(value);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Domain) {
            Domain d = (Domain)obj;
            if (d.size() != this.values.length) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i].equals(d.values[i])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 9;
        int multiplier = 13;
        for (int i = 0; i < this.values.length; ++i) {
            hash = hash * multiplier + this.values[i].hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("{");
        boolean comma = false;
        for (Object value : this.values) {
            if (comma) {
                result.append(", ");
            }
            result.append(value.toString());
            comma = true;
        }
        result.append("}");
        return result.toString();
    }
}

