/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.csp;

import aima.core.search.csp.Constraint;
import aima.core.search.csp.Domain;
import aima.core.search.csp.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public class CSP {
    private List<Variable> variables = new ArrayList<Variable>();
    private List<Domain> domains = new ArrayList<Domain>();
    private List<Constraint> constraints = new ArrayList<Constraint>();
    private Hashtable<Variable, Integer> varIndexHash = new Hashtable();
    private Hashtable<Variable, List<Constraint>> cnet = new Hashtable();

    public CSP() {
    }

    public CSP(List<Variable> vars) {
        this();
        for (Variable v : vars) {
            this.addVariable(v);
        }
    }

    protected void addVariable(Variable var) {
        if (this.varIndexHash.containsKey(var)) {
            throw new IllegalArgumentException("Variable with same name already exists.");
        }
        Domain emptyDomain = new Domain(Collections.emptyList());
        this.variables.add(var);
        this.domains.add(emptyDomain);
        this.varIndexHash.put(var, this.variables.size() - 1);
        this.cnet.put(var, new ArrayList());
    }

    public List<Variable> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public int indexOf(Variable var) {
        return this.varIndexHash.get(var);
    }

    public Domain getDomain(Variable var) {
        return this.domains.get(this.varIndexHash.get(var));
    }

    public void setDomain(Variable var, Domain domain) {
        this.domains.set(this.indexOf(var), domain);
    }

    public void removeValueFromDomain(Variable var, Object value) {
        Domain currDomain = this.getDomain(var);
        ArrayList<Object> values = new ArrayList<Object>(currDomain.size());
        for (Object v : currDomain) {
            if (v.equals(value)) continue;
            values.add(v);
        }
        this.setDomain(var, new Domain(values));
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
        for (Variable var : constraint.getScope()) {
            this.cnet.get(var).add(constraint);
        }
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public List<Constraint> getConstraints(Variable var) {
        return this.cnet.get(var);
    }

    public Variable getNeighbor(Variable var, Constraint constraint) {
        List<Variable> scope = constraint.getScope();
        if (scope.size() == 2) {
            if (var.equals(scope.get(0))) {
                return scope.get(1);
            }
            if (var.equals(scope.get(1))) {
                return scope.get(0);
            }
        }
        return null;
    }

    public CSP copyDomains() {
        CSP result = new CSP();
        result.variables = this.variables;
        result.domains = new ArrayList<Domain>(this.domains.size());
        result.domains.addAll(this.domains);
        result.constraints = this.constraints;
        result.varIndexHash = this.varIndexHash;
        result.cnet = this.cnet;
        return result;
    }
}

