/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.csp;

import aima.core.search.csp.Assignment;
import aima.core.search.csp.CSP;
import aima.core.search.csp.DomainRestoreInfo;
import aima.core.search.csp.SolutionStrategy;
import aima.core.search.csp.Variable;
import aima.core.util.CancelableThread;

public class BacktrackingStrategy
extends SolutionStrategy {
    @Override
    public Assignment solve(CSP csp) {
        return this.recursiveBackTrackingSearch(csp, new Assignment());
    }

    private Assignment recursiveBackTrackingSearch(CSP csp, Assignment assignment) {
        Assignment result = null;
        if (assignment.isComplete(csp.getVariables()) || CancelableThread.currIsCanceled()) {
            result = assignment;
        } else {
            Variable var = this.selectUnassignedVariable(assignment, csp);
            for (Object value : this.orderDomainValues(var, assignment, csp)) {
                assignment.setAssignment(var, value);
                this.fireStateChanged(assignment, csp);
                if (assignment.isConsistent(csp.getConstraints(var))) {
                    DomainRestoreInfo info = this.inference(var, assignment, csp);
                    if (!info.isEmpty()) {
                        this.fireStateChanged(csp);
                    }
                    if (!info.isEmptyDomainFound() && (result = this.recursiveBackTrackingSearch(csp, assignment)) != null) break;
                    info.restoreDomains(csp);
                }
                assignment.removeAssignment(var);
            }
        }
        return result;
    }

    protected Variable selectUnassignedVariable(Assignment assignment, CSP csp) {
        for (Variable var : csp.getVariables()) {
            if (assignment.hasAssignmentFor(var)) continue;
            return var;
        }
        return null;
    }

    protected Iterable<?> orderDomainValues(Variable var, Assignment assignment, CSP csp) {
        return csp.getDomain(var);
    }

    protected DomainRestoreInfo inference(Variable var, Assignment assignment, CSP csp) {
        return new DomainRestoreInfo().compactify();
    }
}

