/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.csp;

import aima.core.search.csp.CSP;
import aima.core.search.csp.Constraint;
import aima.core.search.csp.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public class Assignment {
    List<Variable> variables = new ArrayList<Variable>();
    Hashtable<Variable, Object> variableToValue = new Hashtable();

    public List<Variable> getVariables() {
        return Collections.unmodifiableList(this.variables);
    }

    public Object getAssignment(Variable var) {
        return this.variableToValue.get(var);
    }

    public void setAssignment(Variable var, Object value) {
        if (!this.variableToValue.containsKey(var)) {
            this.variables.add(var);
        }
        this.variableToValue.put(var, value);
    }

    public void removeAssignment(Variable var) {
        if (this.hasAssignmentFor(var)) {
            this.variables.remove(var);
            this.variableToValue.remove(var);
        }
    }

    public boolean hasAssignmentFor(Variable var) {
        return this.variableToValue.get(var) != null;
    }

    public boolean isConsistent(List<Constraint> constraints) {
        for (Constraint cons : constraints) {
            if (cons.isSatisfiedWith(this)) continue;
            return false;
        }
        return true;
    }

    public boolean isComplete(List<Variable> vars) {
        for (Variable var : vars) {
            if (this.hasAssignmentFor(var)) continue;
            return false;
        }
        return true;
    }

    public boolean isComplete(Variable[] vars) {
        for (Variable var : vars) {
            if (this.hasAssignmentFor(var)) continue;
            return false;
        }
        return true;
    }

    public boolean isSolution(CSP csp) {
        return this.isConsistent(csp.getConstraints()) && this.isComplete(csp.getVariables());
    }

    public Assignment copy() {
        Assignment copy = new Assignment();
        for (Variable var : this.variables) {
            copy.setAssignment(var, this.variableToValue.get(var));
        }
        return copy;
    }

    public String toString() {
        boolean comma = false;
        StringBuffer result = new StringBuffer("{");
        for (Variable var : this.variables) {
            if (comma) {
                result.append(", ");
            }
            result.append(var + "=" + this.variableToValue.get(var));
            comma = true;
        }
        result.append("}");
        return result.toString();
    }
}

