/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.csp;

import aima.core.search.csp.Assignment;
import aima.core.search.csp.CSP;
import aima.core.search.csp.Constraint;
import aima.core.search.csp.Domain;
import aima.core.search.csp.DomainRestoreInfo;
import aima.core.search.csp.Variable;
import aima.core.search.framework.QueueFactory;
import java.util.Queue;

public class AC3Strategy {
    public DomainRestoreInfo reduceDomains(CSP csp) {
        DomainRestoreInfo result = new DomainRestoreInfo();
        Queue<Variable> queue = QueueFactory.createLifoQueue();
        for (Variable var : csp.getVariables()) {
            queue.add(var);
        }
        this.reduceDomains(queue, csp, result);
        return result.compactify();
    }

    public DomainRestoreInfo reduceDomains(Variable var, Object value, CSP csp) {
        DomainRestoreInfo result = new DomainRestoreInfo();
        Domain domain = csp.getDomain(var);
        if (domain.contains(value)) {
            if (domain.size() > 1) {
                Queue<Variable> queue = QueueFactory.createLifoQueue();
                queue.add(var);
                result.storeDomainFor(var, domain);
                csp.setDomain(var, new Domain(new Object[]{value}));
                this.reduceDomains(queue, csp, result);
            }
        } else {
            result.setEmptyDomainFound(true);
        }
        return result.compactify();
    }

    private void reduceDomains(Queue<Variable> queue, CSP csp, DomainRestoreInfo info) {
        while (!queue.isEmpty()) {
            Variable var = queue.remove();
            for (Constraint constraint : csp.getConstraints(var)) {
                Variable neighbor;
                if (constraint.getScope().size() != 2 || !this.revise(neighbor = csp.getNeighbor(var, constraint), var, constraint, csp, info)) continue;
                if (csp.getDomain(neighbor).isEmpty()) {
                    info.setEmptyDomainFound(true);
                    return;
                }
                queue.add(neighbor);
            }
        }
    }

    private boolean revise(Variable xi, Variable xj, Constraint constraint, CSP csp, DomainRestoreInfo info) {
        boolean revised = false;
        Assignment assignment = new Assignment();
        for (Object iValue : csp.getDomain(xi)) {
            assignment.setAssignment(xi, iValue);
            boolean consistentExtensionFound = false;
            for (Object jValue : csp.getDomain(xj)) {
                assignment.setAssignment(xj, jValue);
                if (!constraint.isSatisfiedWith(assignment)) continue;
                consistentExtensionFound = true;
                break;
            }
            if (consistentExtensionFound) continue;
            info.storeDomainFor(xi, csp.getDomain(xi));
            csp.removeValueFromDomain(xi, iValue);
            revised = true;
        }
        return revised;
    }
}

