/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.adversarial;

import aima.core.search.adversarial.AdversarialSearch;
import aima.core.search.adversarial.Game;
import aima.core.search.framework.Metrics;

public class MinimaxSearch<STATE, ACTION, PLAYER>
implements AdversarialSearch<STATE, ACTION> {
    public static final String METRICS_NODES_EXPANDED = "nodesExpanded";
    private Game<STATE, ACTION, PLAYER> game;
    private Metrics metrics = new Metrics();

    public static <STATE, ACTION, PLAYER> MinimaxSearch<STATE, ACTION, PLAYER> createFor(Game<STATE, ACTION, PLAYER> game) {
        return new MinimaxSearch<STATE, ACTION, PLAYER>(game);
    }

    public MinimaxSearch(Game<STATE, ACTION, PLAYER> game) {
        this.game = game;
    }

    @Override
    public ACTION makeDecision(STATE state) {
        this.metrics = new Metrics();
        ACTION result = null;
        double resultValue = Double.NEGATIVE_INFINITY;
        PLAYER player = this.game.getPlayer(state);
        for (ACTION action : this.game.getActions(state)) {
            double value = this.minValue(this.game.getResult(state, action), player);
            if (!(value > resultValue)) continue;
            result = action;
            resultValue = value;
        }
        return result;
    }

    public double maxValue(STATE state, PLAYER player) {
        this.metrics.incrementInt(METRICS_NODES_EXPANDED);
        if (this.game.isTerminal(state)) {
            return this.game.getUtility(state, player);
        }
        double value = Double.NEGATIVE_INFINITY;
        for (ACTION action : this.game.getActions(state)) {
            value = Math.max(value, this.minValue(this.game.getResult(state, action), player));
        }
        return value;
    }

    public double minValue(STATE state, PLAYER player) {
        this.metrics.incrementInt(METRICS_NODES_EXPANDED);
        if (this.game.isTerminal(state)) {
            return this.game.getUtility(state, player);
        }
        double value = Double.POSITIVE_INFINITY;
        for (ACTION action : this.game.getActions(state)) {
            value = Math.min(value, this.maxValue(this.game.getResult(state, action), player));
        }
        return value;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }
}

