/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.adversarial;

import aima.core.search.adversarial.AdversarialSearch;
import aima.core.search.adversarial.Game;
import aima.core.search.framework.Metrics;
import java.util.ArrayList;
import java.util.List;

public class IterativeDeepeningAlphaBetaSearch<STATE, ACTION, PLAYER>
implements AdversarialSearch<STATE, ACTION> {
    public static final String METRICS_NODES_EXPANDED = "nodesExpanded";
    public static final String METRICS_MAX_DEPTH = "maxDepth";
    protected Game<STATE, ACTION, PLAYER> game;
    protected double utilMax;
    protected double utilMin;
    protected int currDepthLimit;
    private boolean heuristicEvaluationUsed;
    private Timer timer;
    private boolean logEnabled;
    private Metrics metrics = new Metrics();

    public static <STATE, ACTION, PLAYER> IterativeDeepeningAlphaBetaSearch<STATE, ACTION, PLAYER> createFor(Game<STATE, ACTION, PLAYER> game, double utilMin, double utilMax, int time) {
        return new IterativeDeepeningAlphaBetaSearch<STATE, ACTION, PLAYER>(game, utilMin, utilMax, time);
    }

    public IterativeDeepeningAlphaBetaSearch(Game<STATE, ACTION, PLAYER> game, double utilMin, double utilMax, int time) {
        this.game = game;
        this.utilMin = utilMin;
        this.utilMax = utilMax;
        this.timer = new Timer(time);
    }

    public void setLogEnabled(boolean b) {
        this.logEnabled = b;
    }

    @Override
    public ACTION makeDecision(STATE state) {
        this.metrics = new Metrics();
        StringBuffer logText = null;
        PLAYER player = this.game.getPlayer(state);
        List results = this.orderActions(state, this.game.getActions(state), player, 0);
        this.timer.start();
        this.currDepthLimit = 0;
        do {
            this.incrementDepthLimit();
            if (this.logEnabled) {
                logText = new StringBuffer("depth " + this.currDepthLimit + ": ");
            }
            this.heuristicEvaluationUsed = false;
            ActionStore<ACTION> newResults = new ActionStore<ACTION>();
            for (ACTION action : results) {
                double value = this.minValue(this.game.getResult(state, action), player, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1);
                if (this.timer.timeOutOccured()) break;
                newResults.add(action, value);
                if (!this.logEnabled) continue;
                logText.append(action + "->" + value + " ");
            }
            if (this.logEnabled) {
                System.out.println(logText);
            }
            if (newResults.size() <= 0) continue;
            results = ((ActionStore)newResults).actions;
            if (!this.timer.timeOutOccured() && (this.hasSafeWinner((Double)((ActionStore)newResults).utilValues.get(0)) || newResults.size() > 1 && this.isSignificantlyBetter((Double)((ActionStore)newResults).utilValues.get(0), (Double)((ActionStore)newResults).utilValues.get(1)))) break;
        } while (!this.timer.timeOutOccured() && this.heuristicEvaluationUsed);
        return (ACTION)results.get(0);
    }

    public double maxValue(STATE state, PLAYER player, double alpha, double beta, int depth) {
        this.updateMetrics(depth);
        if (this.game.isTerminal(state) || depth >= this.currDepthLimit || this.timer.timeOutOccured()) {
            return this.eval(state, player);
        }
        double value = Double.NEGATIVE_INFINITY;
        for (ACTION action : this.orderActions(state, this.game.getActions(state), player, depth)) {
            if ((value = Math.max(value, this.minValue(this.game.getResult(state, action), player, alpha, beta, depth + 1))) >= beta) {
                return value;
            }
            alpha = Math.max(alpha, value);
        }
        return value;
    }

    public double minValue(STATE state, PLAYER player, double alpha, double beta, int depth) {
        this.updateMetrics(depth);
        if (this.game.isTerminal(state) || depth >= this.currDepthLimit || this.timer.timeOutOccured()) {
            return this.eval(state, player);
        }
        double value = Double.POSITIVE_INFINITY;
        for (ACTION action : this.orderActions(state, this.game.getActions(state), player, depth)) {
            if ((value = Math.min(value, this.maxValue(this.game.getResult(state, action), player, alpha, beta, depth + 1))) <= alpha) {
                return value;
            }
            beta = Math.min(beta, value);
        }
        return value;
    }

    private void updateMetrics(int depth) {
        this.metrics.incrementInt(METRICS_NODES_EXPANDED);
        this.metrics.set(METRICS_MAX_DEPTH, Math.max(this.metrics.getInt(METRICS_MAX_DEPTH), depth));
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    protected void incrementDepthLimit() {
        ++this.currDepthLimit;
    }

    protected boolean isSignificantlyBetter(double newUtility, double utility) {
        return false;
    }

    protected boolean hasSafeWinner(double resultUtility) {
        return resultUtility <= this.utilMin || resultUtility >= this.utilMax;
    }

    protected double eval(STATE state, PLAYER player) {
        if (this.game.isTerminal(state)) {
            return this.game.getUtility(state, player);
        }
        this.heuristicEvaluationUsed = true;
        return (this.utilMin + this.utilMax) / 2.0;
    }

    public List<ACTION> orderActions(STATE state, List<ACTION> actions, PLAYER player, int depth) {
        return actions;
    }

    private static class ActionStore<ACTION> {
        private List<ACTION> actions = new ArrayList<ACTION>();
        private List<Double> utilValues = new ArrayList<Double>();

        private ActionStore() {
        }

        void add(ACTION action, double utilValue) {
            int idx;
            for (idx = 0; idx < this.actions.size() && utilValue <= this.utilValues.get(idx); ++idx) {
            }
            this.actions.add(idx, action);
            this.utilValues.add(idx, utilValue);
        }

        int size() {
            return this.actions.size();
        }
    }

    private static class Timer {
        private long duration;
        private long startTime;

        Timer(int maxSeconds) {
            this.duration = 1000L * (long)maxSeconds;
        }

        void start() {
            this.startTime = System.currentTimeMillis();
        }

        boolean timeOutOccured() {
            return System.currentTimeMillis() > this.startTime + this.duration;
        }
    }
}

