/*
 * Decompiled with CFR 0.152.
 */
package aima.core.search.adversarial;

import aima.core.search.adversarial.AdversarialSearch;
import aima.core.search.adversarial.Game;
import aima.core.search.framework.Metrics;

public class AlphaBetaSearch<STATE, ACTION, PLAYER>
implements AdversarialSearch<STATE, ACTION> {
    public static final String METRICS_NODES_EXPANDED = "nodesExpanded";
    Game<STATE, ACTION, PLAYER> game;
    private Metrics metrics = new Metrics();

    public static <STATE, ACTION, PLAYER> AlphaBetaSearch<STATE, ACTION, PLAYER> createFor(Game<STATE, ACTION, PLAYER> game) {
        return new AlphaBetaSearch<STATE, ACTION, PLAYER>(game);
    }

    public AlphaBetaSearch(Game<STATE, ACTION, PLAYER> game) {
        this.game = game;
    }

    @Override
    public ACTION makeDecision(STATE state) {
        this.metrics = new Metrics();
        ACTION result = null;
        double resultValue = Double.NEGATIVE_INFINITY;
        PLAYER player = this.game.getPlayer(state);
        for (ACTION action : this.game.getActions(state)) {
            double value = this.minValue(this.game.getResult(state, action), player, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            if (!(value > resultValue)) continue;
            result = action;
            resultValue = value;
        }
        return result;
    }

    public double maxValue(STATE state, PLAYER player, double alpha, double beta) {
        this.metrics.incrementInt(METRICS_NODES_EXPANDED);
        if (this.game.isTerminal(state)) {
            return this.game.getUtility(state, player);
        }
        double value = Double.NEGATIVE_INFINITY;
        for (ACTION action : this.game.getActions(state)) {
            if ((value = Math.max(value, this.minValue(this.game.getResult(state, action), player, alpha, beta))) >= beta) {
                return value;
            }
            alpha = Math.max(alpha, value);
        }
        return value;
    }

    public double minValue(STATE state, PLAYER player, double alpha, double beta) {
        this.metrics.incrementInt(METRICS_NODES_EXPANDED);
        if (this.game.isTerminal(state)) {
            return this.game.getUtility(state, player);
        }
        double value = Double.POSITIVE_INFINITY;
        for (ACTION action : this.game.getActions(state)) {
            if ((value = Math.min(value, this.maxValue(this.game.getResult(state, action), player, alpha, beta))) <= alpha) {
                return value;
            }
            beta = Math.min(beta, value);
        }
        return value;
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }
}

