/*
 * Decompiled with CFR 0.152.
 */
package aima.core.robotics.impl.map;

import aima.core.robotics.IMclMap;
import aima.core.robotics.datatypes.IMclMove;
import aima.core.robotics.impl.datatypes.AbstractRangeReading;
import aima.core.robotics.impl.datatypes.Angle;
import aima.core.robotics.impl.datatypes.IPose2D;
import aima.core.robotics.impl.map.IPoseFactory;
import aima.core.robotics.impl.map.IRangeReadingFactory;
import aima.core.util.math.geom.CartesianPlot2D;
import aima.core.util.math.geom.IGroupParser;
import aima.core.util.math.geom.shapes.IGeometric2D;
import aima.core.util.math.geom.shapes.Point2D;
import aima.core.util.math.geom.shapes.Ray2D;
import aima.core.util.math.geom.shapes.Rect2D;
import aima.core.util.math.geom.shapes.Vector2D;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;

public final class MclCartesianPlot2D<P extends IPose2D<P, M>, M extends IMclMove<M>, R extends AbstractRangeReading>
implements IMclMap<P, Angle, M, AbstractRangeReading> {
    public static final String OBSTACLE_ID = "obstacles";
    public static final String AREA_ID = "validMovementArea";
    private IPoseFactory<P, M> poseFactory;
    private IRangeReadingFactory<R> rangeReadingFactory;
    private CartesianPlot2D obstacles;
    private CartesianPlot2D areas;
    private Exception obstaclesException;
    private Exception areasException;

    public MclCartesianPlot2D(IGroupParser obstaclesParser, IGroupParser areasParser, IPoseFactory<P, M> poseFactory, IRangeReadingFactory<R> rangeReadingFactory) {
        this.poseFactory = poseFactory;
        this.rangeReadingFactory = rangeReadingFactory;
        this.obstacles = new CartesianPlot2D(obstaclesParser);
        this.areas = new CartesianPlot2D(areasParser);
    }

    public void setSensorRange(double sensorRange) {
        this.obstacles.setRayRange(sensorRange);
        this.areas.setRayRange(sensorRange);
    }

    public P checkDistanceOfPoses(Set<P> samples, double maxDistance) {
        double maxDistanceSamples = 0.0;
        for (IPose2D first : samples) {
            for (IPose2D second : samples) {
                double distance = first.distanceTo(second);
                maxDistanceSamples = distance > maxDistanceSamples ? distance : maxDistanceSamples;
            }
        }
        if (maxDistanceSamples <= maxDistance) {
            double averageX = 0.0;
            double averageY = 0.0;
            double averageHeading = 0.0;
            for (IPose2D sample : samples) {
                averageX += sample.getX() / (double)samples.size();
                averageY += sample.getY() / (double)samples.size();
                averageHeading += sample.getHeading() / (double)samples.size();
            }
            return this.poseFactory.getPose(new Point2D(averageX, averageY), averageHeading);
        }
        return null;
    }

    public void loadMap(final InputStream obstacleInput, final InputStream areaInput) throws Exception {
        this.obstaclesException = null;
        this.areasException = null;
        Thread obstaclesThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MclCartesianPlot2D.this.obstacles.loadMap(obstacleInput, MclCartesianPlot2D.OBSTACLE_ID);
                }
                catch (Exception e) {
                    MclCartesianPlot2D.this.obstaclesException = e;
                }
            }
        });
        Thread areasThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    MclCartesianPlot2D.this.areas.loadMap(areaInput, MclCartesianPlot2D.AREA_ID);
                }
                catch (Exception e) {
                    MclCartesianPlot2D.this.areasException = e;
                }
            }
        });
        obstaclesThread.setDaemon(true);
        areasThread.setDaemon(true);
        obstaclesThread.start();
        areasThread.start();
        try {
            obstaclesThread.join();
            areasThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.obstaclesException != null) {
            throw this.obstaclesException;
        }
        if (this.areasException != null) {
            throw this.areasException;
        }
    }

    public Iterator<IGeometric2D> getObstacles() {
        return this.obstacles.getShapes();
    }

    public Iterator<Rect2D> getObstacleBoundaries() {
        return this.obstacles.getBoundaries();
    }

    public Iterator<IGeometric2D> getAreas() {
        return this.areas.getShapes();
    }

    public Iterator<Rect2D> getAreaBoundaries() {
        return this.areas.getBoundaries();
    }

    public boolean isLoaded() {
        return !this.areas.isEmpty();
    }

    @Override
    public P randomPose() {
        Point2D point;
        while (this.obstacles.isPointInsideShape(point = this.areas.randomPoint())) {
        }
        return this.poseFactory.getPose(point);
    }

    @Override
    public R rayCast(P pose) {
        Ray2D ray = new Ray2D(new Point2D(pose.getX(), pose.getY()), Vector2D.calculateFromPolar(1.0, -pose.getHeading()));
        return this.rangeReadingFactory.getRangeReading(this.obstacles.rayCast(ray));
    }

    @Override
    public boolean isPoseValid(P pose) {
        if (!this.poseFactory.isHeadingValid(pose)) {
            return false;
        }
        Point2D point = new Point2D(pose.getX(), pose.getY());
        return this.areas.isPointInsideBorderShape(point) && !this.obstacles.isPointInsideShape(point);
    }
}

