/*
 * Decompiled with CFR 0.152.
 */
package aima.core.robotics.impl.datatypes;

import aima.core.robotics.datatypes.IMclVector;
import aima.core.util.Util;

public class Angle
implements IMclVector,
Comparable<Angle> {
    public static final Angle ZERO_ANGLE = new Angle(0.0);
    private final double value;

    public Angle(double value) {
        this.value = value;
    }

    public static Angle degreeAngle(double value) {
        return new Angle(Math.toRadians(value));
    }

    public double getValue() {
        return this.value;
    }

    public double getDegreeValue() {
        return Math.toDegrees(this.value);
    }

    @Override
    public int compareTo(Angle o) {
        if (Util.compareDoubles(this.value, o.value)) {
            return 0;
        }
        if (this.value < o.value) {
            return -1;
        }
        return 1;
    }
}

