/*
 * Decompiled with CFR 0.152.
 */
package aima.core.robotics;

import aima.core.probability.domain.FiniteIntegerDomain;
import aima.core.probability.util.ProbUtil;
import aima.core.probability.util.RandVar;
import aima.core.robotics.IMclMap;
import aima.core.robotics.datatypes.IMclMove;
import aima.core.robotics.datatypes.IMclPose;
import aima.core.robotics.datatypes.IMclRangeReading;
import aima.core.robotics.datatypes.IMclVector;
import aima.core.util.Randomizer;
import aima.core.util.Util;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public final class MonteCarloLocalization<P extends IMclPose<P, V, M>, V extends IMclVector, M extends IMclMove<M>, R extends IMclRangeReading<R, V>> {
    private static final String SAMPLE_INDEXES_NAME = "SAMPLE_INDEXES";
    private final IMclMap<P, V, M, R> map;
    private final Randomizer randomizer;
    private RandVar sampleIndexes;
    private double weightCutOff;

    public MonteCarloLocalization(IMclMap<P, V, M, R> map, Randomizer randomizer) {
        this.map = map;
        this.randomizer = randomizer;
    }

    public void setWeightCutOff(double cutOff) {
        this.weightCutOff = cutOff;
    }

    protected Set<P> applyMove(Set<P> samples, M move) {
        LinkedHashSet newSamples = new LinkedHashSet();
        for (IMclPose sample : samples) {
            newSamples.add(sample.applyMovement(move.generateNoise()));
        }
        return newSamples;
    }

    protected double[] weightSamples(Set<P> samples, R[] rangeReadings) {
        Iterator<P> samplesIterator = samples.iterator();
        double[] w = new double[samples.size()];
        for (int j = 0; j < samples.size(); ++j) {
            IMclPose sample = (IMclPose)samplesIterator.next();
            if (this.map.isPoseValid(sample)) {
                w[j] = 1.0;
                for (int i = 0; i < rangeReadings.length; ++i) {
                    w[j] = w[j] * rangeReadings[i].calculateWeight(this.map.rayCast(sample.addAngle(rangeReadings[i].getAngle())));
                }
                continue;
            }
            w[j] = 0.0;
        }
        return w;
    }

    protected Set<P> extendedWeightedSampleWithReplacement(Set<P> samples, double[] w) {
        int i;
        for (i = 0; i < samples.size() && !(w[i] > this.weightCutOff); ++i) {
        }
        if (i >= samples.size()) {
            return this.generateCloud(samples.size());
        }
        double[] normalizedW = Util.normalize(w);
        LinkedHashSet newSamples = new LinkedHashSet();
        Object[] array = samples.toArray(new Object[0]);
        for (i = 0; i < samples.size(); ++i) {
            int selectedSample = (Integer)ProbUtil.sample(this.randomizer.nextDouble(), this.sampleIndexes, normalizedW);
            newSamples.add(((IMclPose)array[selectedSample]).clone());
        }
        return newSamples;
    }

    public Set<P> generateCloud(int N) {
        LinkedHashSet<P> samples = new LinkedHashSet<P>();
        Integer[] indexes = new Integer[N];
        for (int i = 0; i < N; ++i) {
            samples.add(this.map.randomPose());
            indexes[i] = i;
        }
        this.sampleIndexes = new RandVar(SAMPLE_INDEXES_NAME, new FiniteIntegerDomain(indexes));
        return samples;
    }

    public Set<P> localize(Set<P> samples, M move, R[] rangeReadings) {
        if (samples == null) {
            return null;
        }
        Set<P> newSamples = this.applyMove(samples, move);
        double[] w = this.weightSamples(newSamples, (IMclRangeReading[])rangeReadings);
        newSamples = this.extendedWeightedSampleWithReplacement(newSamples, w);
        return newSamples;
    }
}

