/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.util;

import aima.core.probability.RandomVariable;
import aima.core.probability.domain.Domain;
import aima.core.probability.proposition.TermProposition;
import aima.core.probability.util.ProbUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RandVar
implements RandomVariable,
TermProposition {
    private String name = null;
    private Domain domain = null;
    private Set<RandomVariable> scope = new HashSet<RandomVariable>();

    public RandVar(String name, Domain domain) {
        ProbUtil.checkValidRandomVariableName(name);
        if (null == domain) {
            throw new IllegalArgumentException("Domain of RandomVariable must be specified.");
        }
        this.name = name;
        this.domain = domain;
        this.scope.add(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Domain getDomain() {
        return this.domain;
    }

    @Override
    public RandomVariable getTermVariable() {
        return this;
    }

    @Override
    public Set<RandomVariable> getScope() {
        return this.scope;
    }

    @Override
    public Set<RandomVariable> getUnboundScope() {
        return this.scope;
    }

    @Override
    public boolean holds(Map<RandomVariable, Object> possibleWorld) {
        return possibleWorld.containsKey(this.getTermVariable());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RandomVariable)) {
            return false;
        }
        RandomVariable other = (RandomVariable)o;
        return this.name.equals(other.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

