/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.util;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.Factor;
import aima.core.probability.RandomVariable;
import aima.core.probability.domain.FiniteDomain;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.probability.util.ProbUtil;
import aima.core.util.SetOps;
import aima.core.util.math.MixedRadixNumber;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ProbabilityTable
implements CategoricalDistribution,
Factor {
    private double[] values = null;
    private Map<RandomVariable, RVInfo> randomVarInfo = new LinkedHashMap<RandomVariable, RVInfo>();
    private int[] radices = null;
    private MixedRadixNumber queryMRN = null;
    private String toString = null;
    private double sum = -1.0;

    public ProbabilityTable(Collection<RandomVariable> vars) {
        this(vars.toArray(new RandomVariable[vars.size()]));
    }

    public ProbabilityTable(RandomVariable ... vars) {
        this(new double[ProbUtil.expectedSizeOfProbabilityTable(vars)], vars);
    }

    public ProbabilityTable(double[] vals, RandomVariable ... vars) {
        if (null == vals) {
            throw new IllegalArgumentException("Values must be specified");
        }
        if (vals.length != ProbUtil.expectedSizeOfProbabilityTable(vars)) {
            throw new IllegalArgumentException("ProbabilityTable of length " + vals.length + " is not the correct size, should be " + ProbUtil.expectedSizeOfProbabilityTable(vars) + " in order to represent all possible combinations.");
        }
        if (null != vars) {
            for (RandomVariable rv : vars) {
                this.randomVarInfo.put(rv, new RVInfo(rv));
            }
        }
        this.values = new double[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
        this.radices = this.createRadixs(this.randomVarInfo);
        if (this.radices.length > 0) {
            this.queryMRN = new MixedRadixNumber(0L, this.radices);
        }
    }

    public int size() {
        return this.values.length;
    }

    @Override
    public Set<RandomVariable> getFor() {
        return this.randomVarInfo.keySet();
    }

    @Override
    public boolean contains(RandomVariable rv) {
        return this.randomVarInfo.keySet().contains(rv);
    }

    @Override
    public double getValue(Object ... assignments) {
        return this.values[this.getIndex(assignments)];
    }

    @Override
    public double getValue(AssignmentProposition ... assignments) {
        if (assignments.length != this.randomVarInfo.size()) {
            throw new IllegalArgumentException("Assignments passed in is not the same size as variables making up probability table.");
        }
        int[] radixValues = new int[assignments.length];
        for (AssignmentProposition ap : assignments) {
            RVInfo rvInfo = this.randomVarInfo.get(ap.getTermVariable());
            if (null == rvInfo) {
                throw new IllegalArgumentException("Assignment passed for a variable that is not part of this probability table:" + ap.getTermVariable());
            }
            radixValues[rvInfo.getRadixIdx()] = rvInfo.getIdxForDomain(ap.getValue());
        }
        return this.values[(int)this.queryMRN.getCurrentValueFor(radixValues)];
    }

    @Override
    public double[] getValues() {
        return this.values;
    }

    @Override
    public void setValue(int idx, double value) {
        this.values[idx] = value;
        this.reinitLazyValues();
    }

    @Override
    public double getSum() {
        if (-1.0 == this.sum) {
            this.sum = 0.0;
            for (int i = 0; i < this.values.length; ++i) {
                this.sum += this.values[i];
            }
        }
        return this.sum;
    }

    @Override
    public ProbabilityTable normalize() {
        double s = this.getSum();
        if (s != 0.0 && s != 1.0) {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = this.values[i] / s;
            }
            this.reinitLazyValues();
        }
        return this;
    }

    @Override
    public int getIndex(Object ... assignments) {
        if (assignments.length != this.randomVarInfo.size()) {
            throw new IllegalArgumentException("Assignments passed in is not the same size as variables making up the table.");
        }
        int[] radixValues = new int[assignments.length];
        int i = 0;
        for (RVInfo rvInfo : this.randomVarInfo.values()) {
            radixValues[rvInfo.getRadixIdx()] = rvInfo.getIdxForDomain(assignments[i]);
            ++i;
        }
        return (int)this.queryMRN.getCurrentValueFor(radixValues);
    }

    @Override
    public CategoricalDistribution marginal(RandomVariable ... vars) {
        return this.sumOut(vars);
    }

    @Override
    public CategoricalDistribution divideBy(CategoricalDistribution divisor) {
        return this.divideBy((ProbabilityTable)divisor);
    }

    @Override
    public CategoricalDistribution multiplyBy(CategoricalDistribution multiplier) {
        return this.pointwiseProduct((ProbabilityTable)multiplier);
    }

    @Override
    public CategoricalDistribution multiplyByPOS(CategoricalDistribution multiplier, RandomVariable ... prodVarOrder) {
        return this.pointwiseProductPOS((ProbabilityTable)multiplier, prodVarOrder);
    }

    @Override
    public void iterateOver(CategoricalDistribution.Iterator cdi) {
        this.iterateOverTable(new CategoricalDistributionIteratorAdapter(cdi));
    }

    @Override
    public void iterateOver(CategoricalDistribution.Iterator cdi, AssignmentProposition ... fixedValues) {
        this.iterateOverTable(new CategoricalDistributionIteratorAdapter(cdi), fixedValues);
    }

    @Override
    public Set<RandomVariable> getArgumentVariables() {
        return this.randomVarInfo.keySet();
    }

    @Override
    public ProbabilityTable sumOut(RandomVariable ... vars) {
        LinkedHashSet<RandomVariable> soutVars = new LinkedHashSet<RandomVariable>(this.randomVarInfo.keySet());
        for (RandomVariable rv : vars) {
            soutVars.remove(rv);
        }
        final ProbabilityTable summedOut = new ProbabilityTable(soutVars);
        if (1 == summedOut.getValues().length) {
            summedOut.getValues()[0] = this.getSum();
        } else {
            final Object[] termValues = new Object[summedOut.randomVarInfo.size()];
            Iterator di = new Iterator(){

                @Override
                public void iterate(Map<RandomVariable, Object> possibleWorld, double probability) {
                    int i = 0;
                    for (RandomVariable rv : summedOut.randomVarInfo.keySet()) {
                        termValues[i] = possibleWorld.get(rv);
                        ++i;
                    }
                    double[] dArray = summedOut.getValues();
                    int n = summedOut.getIndex(termValues);
                    dArray[n] = dArray[n] + probability;
                }
            };
            this.iterateOverTable(di);
        }
        return summedOut;
    }

    @Override
    public Factor pointwiseProduct(Factor multiplier) {
        return this.pointwiseProduct((ProbabilityTable)multiplier);
    }

    @Override
    public Factor pointwiseProductPOS(Factor multiplier, RandomVariable ... prodVarOrder) {
        return this.pointwiseProductPOS((ProbabilityTable)multiplier, prodVarOrder);
    }

    @Override
    public void iterateOver(Factor.Iterator fi) {
        this.iterateOverTable(new FactorIteratorAdapter(fi));
    }

    @Override
    public void iterateOver(Factor.Iterator fi, AssignmentProposition ... fixedValues) {
        this.iterateOverTable(new FactorIteratorAdapter(fi), fixedValues);
    }

    public void iterateOverTable(Iterator pti) {
        LinkedHashMap<RandomVariable, Object> possibleWorld = new LinkedHashMap<RandomVariable, Object>();
        MixedRadixNumber mrn = new MixedRadixNumber(0L, this.radices);
        do {
            for (RVInfo rvInfo : this.randomVarInfo.values()) {
                possibleWorld.put(rvInfo.getVariable(), rvInfo.getDomainValueAt(mrn.getCurrentNumeralValue(rvInfo.getRadixIdx())));
            }
            pti.iterate(possibleWorld, this.values[mrn.intValue()]);
        } while (mrn.increment());
    }

    public void iterateOverTable(Iterator pti, AssignmentProposition ... fixedValues) {
        LinkedHashMap<RandomVariable, Object> possibleWorld = new LinkedHashMap<RandomVariable, Object>();
        MixedRadixNumber tableMRN = new MixedRadixNumber(0L, this.radices);
        int[] tableRadixValues = new int[this.radices.length];
        for (AssignmentProposition ap : fixedValues) {
            if (!this.randomVarInfo.containsKey(ap.getTermVariable())) {
                throw new IllegalArgumentException("Assignment proposition [" + ap + "] does not belong to this probability table.");
            }
            possibleWorld.put(ap.getTermVariable(), ap.getValue());
            RVInfo fixedRVI = this.randomVarInfo.get(ap.getTermVariable());
            tableRadixValues[fixedRVI.getRadixIdx()] = fixedRVI.getIdxForDomain(ap.getValue());
        }
        if (fixedValues.length == this.randomVarInfo.size()) {
            pti.iterate(possibleWorld, this.getValue(fixedValues));
        } else {
            Set<RandomVariable> freeVariables = SetOps.difference(this.randomVarInfo.keySet(), possibleWorld.keySet());
            LinkedHashMap<RandomVariable, RVInfo> freeVarInfo = new LinkedHashMap<RandomVariable, RVInfo>();
            for (RandomVariable fv : freeVariables) {
                freeVarInfo.put(fv, new RVInfo(fv));
            }
            int[] freeRadixValues = this.createRadixs(freeVarInfo);
            MixedRadixNumber freeMRN = new MixedRadixNumber(0L, freeRadixValues);
            Object fval = null;
            do {
                for (RVInfo freeRVI : freeVarInfo.values()) {
                    fval = freeRVI.getDomainValueAt(freeMRN.getCurrentNumeralValue(freeRVI.getRadixIdx()));
                    possibleWorld.put(freeRVI.getVariable(), fval);
                    tableRadixValues[this.randomVarInfo.get((Object)freeRVI.getVariable()).getRadixIdx()] = freeRVI.getIdxForDomain(fval);
                }
                pti.iterate(possibleWorld, this.values[(int)tableMRN.getCurrentValueFor(tableRadixValues)]);
            } while (freeMRN.increment());
        }
    }

    public ProbabilityTable divideBy(ProbabilityTable divisor) {
        if (!this.randomVarInfo.keySet().containsAll(divisor.randomVarInfo.keySet())) {
            throw new IllegalArgumentException("Divisor must be a subset of the dividend.");
        }
        final ProbabilityTable quotient = new ProbabilityTable(this.randomVarInfo.keySet());
        if (1 == divisor.getValues().length) {
            double d = divisor.getValues()[0];
            for (int i = 0; i < quotient.getValues().length; ++i) {
                quotient.getValues()[i] = 0.0 == d ? 0.0 : this.getValues()[i] / d;
            }
        } else {
            Set<RandomVariable> dividendDivisorDiff = SetOps.difference(this.randomVarInfo.keySet(), divisor.randomVarInfo.keySet());
            LinkedHashMap<RandomVariable, RVInfo> tdiff = null;
            MixedRadixNumber tdMRN = null;
            if (dividendDivisorDiff.size() > 0) {
                tdiff = new LinkedHashMap<RandomVariable, RVInfo>();
                for (RandomVariable rv : dividendDivisorDiff) {
                    tdiff.put(rv, new RVInfo(rv));
                }
                tdMRN = new MixedRadixNumber(0L, this.createRadixs(tdiff));
            }
            final LinkedHashMap<RandomVariable, RVInfo> diff = tdiff;
            final MixedRadixNumber dMRN = tdMRN;
            final int[] qRVs = new int[quotient.radices.length];
            final MixedRadixNumber qMRN = new MixedRadixNumber(0L, quotient.radices);
            Iterator divisorIterator = new Iterator(){

                @Override
                public void iterate(Map<RandomVariable, Object> possibleWorld, double probability) {
                    for (RandomVariable rv : possibleWorld.keySet()) {
                        RVInfo rvInfo = (RVInfo)quotient.randomVarInfo.get(rv);
                        qRVs[rvInfo.getRadixIdx()] = rvInfo.getIdxForDomain(possibleWorld.get(rv));
                    }
                    if (null != diff) {
                        dMRN.setCurrentValueFor(new int[diff.size()]);
                        do {
                            for (RandomVariable rv : diff.keySet()) {
                                RVInfo drvInfo = (RVInfo)diff.get(rv);
                                RVInfo qrvInfo = (RVInfo)quotient.randomVarInfo.get(rv);
                                qRVs[qrvInfo.getRadixIdx()] = dMRN.getCurrentNumeralValue(drvInfo.getRadixIdx());
                            }
                            this.updateQuotient(probability);
                        } while (dMRN.increment());
                    } else {
                        this.updateQuotient(probability);
                    }
                }

                private void updateQuotient(double probability) {
                    int offset = (int)qMRN.getCurrentValueFor(qRVs);
                    if (0.0 == probability) {
                        quotient.getValues()[offset] = 0.0;
                    } else {
                        double[] dArray = quotient.getValues();
                        int n = offset;
                        dArray[n] = dArray[n] + ProbabilityTable.this.getValues()[offset] / probability;
                    }
                }
            };
            divisor.iterateOverTable(divisorIterator);
        }
        return quotient;
    }

    public ProbabilityTable pointwiseProduct(ProbabilityTable multiplier) {
        Set<RandomVariable> prodVars = SetOps.union(this.randomVarInfo.keySet(), multiplier.randomVarInfo.keySet());
        return this.pointwiseProductPOS(multiplier, prodVars.toArray(new RandomVariable[prodVars.size()]));
    }

    public ProbabilityTable pointwiseProductPOS(final ProbabilityTable multiplier, RandomVariable ... prodVarOrder) {
        final ProbabilityTable product = new ProbabilityTable(prodVarOrder);
        if (!product.randomVarInfo.keySet().equals(SetOps.union(this.randomVarInfo.keySet(), multiplier.randomVarInfo.keySet()))) {
            throw new IllegalArgumentException("Specified list deatailing order of mulitplier is inconsistent.");
        }
        if (1 == product.getValues().length) {
            product.getValues()[0] = this.getValues()[0] * multiplier.getValues()[0];
        } else {
            final Object[] term1Values = new Object[this.randomVarInfo.size()];
            final Object[] term2Values = new Object[multiplier.randomVarInfo.size()];
            Iterator di = new Iterator(){
                private int idx = 0;

                @Override
                public void iterate(Map<RandomVariable, Object> possibleWorld, double probability) {
                    int term1Idx = this.termIdx(term1Values, ProbabilityTable.this, possibleWorld);
                    int term2Idx = this.termIdx(term2Values, multiplier, possibleWorld);
                    product.getValues()[this.idx] = ProbabilityTable.this.getValues()[term1Idx] * multiplier.getValues()[term2Idx];
                    ++this.idx;
                }

                private int termIdx(Object[] termValues, ProbabilityTable d, Map<RandomVariable, Object> possibleWorld) {
                    if (0 == termValues.length) {
                        return 0;
                    }
                    int i = 0;
                    for (RandomVariable rv : d.randomVarInfo.keySet()) {
                        termValues[i] = possibleWorld.get(rv);
                        ++i;
                    }
                    return d.getIndex(termValues);
                }
            };
            product.iterateOverTable(di);
        }
        return product;
    }

    public String toString() {
        if (null == this.toString) {
            StringBuilder sb = new StringBuilder();
            sb.append("<");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.values[i]);
            }
            sb.append(">");
            this.toString = sb.toString();
        }
        return this.toString;
    }

    private void reinitLazyValues() {
        this.sum = -1.0;
        this.toString = null;
    }

    private int[] createRadixs(Map<RandomVariable, RVInfo> mapRtoInfo) {
        int[] r = new int[mapRtoInfo.size()];
        int x = mapRtoInfo.size() - 1;
        for (RVInfo rvInfo : mapRtoInfo.values()) {
            r[x] = rvInfo.getDomainSize();
            rvInfo.setRadixIdx(x);
            --x;
        }
        return r;
    }

    private class FactorIteratorAdapter
    implements Iterator {
        private Factor.Iterator fi = null;

        public FactorIteratorAdapter(Factor.Iterator fi) {
            this.fi = fi;
        }

        @Override
        public void iterate(Map<RandomVariable, Object> possibleAssignment, double probability) {
            this.fi.iterate(possibleAssignment, probability);
        }
    }

    private class CategoricalDistributionIteratorAdapter
    implements Iterator {
        private CategoricalDistribution.Iterator cdi = null;

        public CategoricalDistributionIteratorAdapter(CategoricalDistribution.Iterator cdi) {
            this.cdi = cdi;
        }

        @Override
        public void iterate(Map<RandomVariable, Object> possibleAssignment, double probability) {
            this.cdi.iterate(possibleAssignment, probability);
        }
    }

    private class RVInfo {
        private RandomVariable variable;
        private FiniteDomain varDomain;
        private int radixIdx = 0;

        public RVInfo(RandomVariable rv) {
            this.variable = rv;
            this.varDomain = (FiniteDomain)this.variable.getDomain();
        }

        public RandomVariable getVariable() {
            return this.variable;
        }

        public int getDomainSize() {
            return this.varDomain.size();
        }

        public int getIdxForDomain(Object value) {
            return this.varDomain.getOffset(value);
        }

        public Object getDomainValueAt(int idx) {
            return this.varDomain.getValueAt(idx);
        }

        public void setRadixIdx(int idx) {
            this.radixIdx = idx;
        }

        public int getRadixIdx() {
            return this.radixIdx;
        }
    }

    public static interface Iterator {
        public void iterate(Map<RandomVariable, Object> var1, double var2);
    }
}

