/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.util;

import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.Node;
import aima.core.probability.domain.FiniteDomain;
import aima.core.probability.proposition.ConjunctiveProposition;
import aima.core.probability.proposition.Proposition;
import aima.core.util.Randomizer;
import aima.core.util.Util;
import aima.core.util.math.MixedRadixNumber;
import java.util.Map;

public class ProbUtil {
    public static void checkValidRandomVariableName(String name) throws IllegalArgumentException {
        if (null == name || name.trim().length() == 0 || name.trim().length() != name.length() || name.contains(" ")) {
            throw new IllegalArgumentException("Name of RandomVariable must be specified and contain no leading, trailing or embedded spaces.");
        }
        if (name.substring(0, 1).toLowerCase().equals(name.substring(0, 1))) {
            throw new IllegalArgumentException("Name must start with a leading upper case letter.");
        }
    }

    public static int expectedSizeOfProbabilityTable(RandomVariable ... vars) {
        int expectedSizeOfDistribution = 1;
        if (null != vars) {
            for (RandomVariable rv : vars) {
                if (!(rv.getDomain() instanceof FiniteDomain)) {
                    throw new IllegalArgumentException("Cannot have an infinite domain for a variable in this calculation:" + rv);
                }
                FiniteDomain d = (FiniteDomain)rv.getDomain();
                expectedSizeOfDistribution *= d.size();
            }
        }
        return expectedSizeOfDistribution;
    }

    public static int expectedSizeOfCategoricalDistribution(RandomVariable ... vars) {
        return ProbUtil.expectedSizeOfProbabilityTable(vars);
    }

    public static Proposition constructConjunction(Proposition[] props) {
        return ProbUtil.constructConjunction(props, 0);
    }

    public static Object sample(double probabilityChoice, RandomVariable Xi, double[] distribution) {
        FiniteDomain fd = (FiniteDomain)Xi.getDomain();
        if (fd.size() != distribution.length) {
            throw new IllegalArgumentException("Size of domain Xi " + fd.size() + " is not equal to the size of the distribution " + distribution.length);
        }
        int i = 0;
        for (double total = distribution[0]; probabilityChoice > total; total += distribution[++i]) {
        }
        return fd.getValueAt(i);
    }

    public static Object randomSample(Node Xi, Map<RandomVariable, Object> event, Randomizer r) {
        return Xi.getCPD().getSample(r.nextDouble(), ProbUtil.getEventValuesForParents(Xi, event));
    }

    public static Object mbRandomSample(Node Xi, Map<RandomVariable, Object> event, Randomizer r) {
        return ProbUtil.sample(r.nextDouble(), Xi.getRandomVariable(), ProbUtil.mbDistribution(Xi, event));
    }

    public static double[] mbDistribution(Node Xi, Map<RandomVariable, Object> event) {
        FiniteDomain fd = (FiniteDomain)Xi.getRandomVariable().getDomain();
        double[] X = new double[fd.size()];
        for (int i = 0; i < fd.size(); ++i) {
            double cprob = 1.0;
            for (Node Yj : Xi.getChildren()) {
                cprob *= Yj.getCPD().getValue(ProbUtil.getEventValuesForXiGivenParents(Yj, event));
            }
            X[i] = Xi.getCPD().getValue(ProbUtil.getEventValuesForXiGivenParents(Xi, fd.getValueAt(i), event)) * cprob;
        }
        return Util.normalize(X);
    }

    public static Object[] getEventValuesForParents(Node Xi, Map<RandomVariable, Object> event) {
        Object[] parentValues = new Object[Xi.getParents().size()];
        int i = 0;
        for (Node pn : Xi.getParents()) {
            parentValues[i] = event.get(pn.getRandomVariable());
            ++i;
        }
        return parentValues;
    }

    public static Object[] getEventValuesForXiGivenParents(Node Xi, Map<RandomVariable, Object> event) {
        return ProbUtil.getEventValuesForXiGivenParents(Xi, event.get(Xi.getRandomVariable()), event);
    }

    public static Object[] getEventValuesForXiGivenParents(Node Xi, Object xDelta, Map<RandomVariable, Object> event) {
        Object[] values = new Object[Xi.getParents().size() + 1];
        int idx = 0;
        for (Node pn : Xi.getParents()) {
            values[idx] = event.get(pn.getRandomVariable());
            ++idx;
        }
        values[idx] = xDelta;
        return values;
    }

    public static int indexOf(RandomVariable[] X, Map<RandomVariable, Object> x) {
        if (0 == X.length) {
            return ((FiniteDomain)X[0].getDomain()).getOffset(x.get(X[0]));
        }
        int[] radixValues = new int[X.length];
        int[] radices = new int[X.length];
        int j = X.length - 1;
        for (int i = 0; i < X.length; ++i) {
            FiniteDomain fd = (FiniteDomain)X[i].getDomain();
            radixValues[j] = fd.getOffset(x.get(X[i]));
            radices[j] = fd.size();
            --j;
        }
        return new MixedRadixNumber(radixValues, radices).intValue();
    }

    public static int[] indexesOfValue(RandomVariable[] X, int idx, Map<RandomVariable, Object> x) {
        int i;
        int csize = ProbUtil.expectedSizeOfCategoricalDistribution(X);
        FiniteDomain fd = (FiniteDomain)X[idx].getDomain();
        int vdoffset = fd.getOffset(x.get(X[idx]));
        int vdosize = fd.size();
        int[] indexes = new int[csize / vdosize];
        int blocksize = csize;
        for (i = 0; i < X.length; ++i) {
            blocksize /= X[i].getDomain().size();
            if (i == idx) break;
        }
        for (i = 0; i < indexes.length; i += blocksize) {
            int offset = i / blocksize * vdosize * blocksize + blocksize * vdoffset;
            for (int b = 0; b < blocksize; ++b) {
                indexes[i + b] = offset + b;
            }
        }
        return indexes;
    }

    private static Proposition constructConjunction(Proposition[] props, int idx) {
        if (idx + 1 == props.length) {
            return props[idx];
        }
        return new ConjunctiveProposition(props[idx], ProbUtil.constructConjunction(props, idx + 1));
    }
}

