/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.temporal.generic;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.FiniteProbabilityModel;
import aima.core.probability.RandomVariable;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.probability.proposition.Proposition;
import aima.core.probability.temporal.ForwardBackwardInference;
import aima.core.probability.util.ProbUtil;
import aima.core.probability.util.ProbabilityTable;
import aima.core.probability.util.RandVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ForwardBackward
implements ForwardBackwardInference {
    private FiniteProbabilityModel transitionModel = null;
    private Map<RandomVariable, RandomVariable> tToTm1StateVarMap = new HashMap<RandomVariable, RandomVariable>();
    private FiniteProbabilityModel sensorModel = null;

    public ForwardBackward(FiniteProbabilityModel transitionModel, Map<RandomVariable, RandomVariable> tToTm1StateVarMap, FiniteProbabilityModel sensorModel) {
        this.transitionModel = transitionModel;
        this.tToTm1StateVarMap.putAll(tToTm1StateVarMap);
        this.sensorModel = sensorModel;
    }

    @Override
    public List<CategoricalDistribution> forwardBackward(List<List<AssignmentProposition>> ev, CategoricalDistribution prior) {
        int i;
        ArrayList<CategoricalDistribution> fv = new ArrayList<CategoricalDistribution>(ev.size() + 1);
        CategoricalDistribution b = this.initBackwardMessage();
        ArrayList<CategoricalDistribution> sv = new ArrayList<CategoricalDistribution>(ev.size());
        fv.add(prior);
        for (i = 0; i < ev.size(); ++i) {
            fv.add(this.forward((CategoricalDistribution)fv.get(i), ev.get(i)));
        }
        for (i = ev.size() - 1; i >= 0; --i) {
            sv.add(0, ((CategoricalDistribution)fv.get(i + 1)).multiplyBy(b).normalize());
            b = this.backward(b, ev.get(i));
        }
        return sv;
    }

    @Override
    public CategoricalDistribution forward(CategoricalDistribution f1_t, List<AssignmentProposition> e_tp1) {
        final ProbabilityTable s1 = new ProbabilityTable(f1_t.getFor());
        Proposition[] props = new Proposition[s1.getFor().size()];
        int i = 0;
        for (RandomVariable rv : s1.getFor()) {
            props[i] = new RandVar(rv.getName(), rv.getDomain());
            ++i;
        }
        final Proposition Xtp1 = ProbUtil.constructConjunction(props);
        final AssignmentProposition[] xt = new AssignmentProposition[this.tToTm1StateVarMap.size()];
        final HashMap<RandomVariable, AssignmentProposition> xtVarAssignMap = new HashMap<RandomVariable, AssignmentProposition>();
        i = 0;
        for (RandomVariable rv : this.tToTm1StateVarMap.keySet()) {
            xt[i] = new AssignmentProposition(this.tToTm1StateVarMap.get(rv), "<Dummy Value>");
            xtVarAssignMap.put(rv, xt[i]);
            ++i;
        }
        CategoricalDistribution.Iterator if1_t = new CategoricalDistribution.Iterator(){

            @Override
            public void iterate(Map<RandomVariable, Object> possibleWorld, double probability) {
                for (Map.Entry<RandomVariable, Object> av : possibleWorld.entrySet()) {
                    ((AssignmentProposition)xtVarAssignMap.get(av.getKey())).setValue(av.getValue());
                }
                int i = 0;
                for (double tp : ForwardBackward.this.transitionModel.posteriorDistribution(Xtp1, xt).getValues()) {
                    s1.setValue(i, s1.getValues()[i] + tp * probability);
                    ++i;
                }
            }
        };
        f1_t.iterateOver(if1_t);
        CategoricalDistribution s2 = this.sensorModel.posteriorDistribution(ProbUtil.constructConjunction(e_tp1.toArray(new Proposition[e_tp1.size()])), Xtp1);
        return s2.multiplyBy(s1).normalize();
    }

    @Override
    public CategoricalDistribution backward(CategoricalDistribution b_kp2t, List<AssignmentProposition> e_kp1) {
        final ProbabilityTable b_kp1t = new ProbabilityTable(b_kp2t.getFor());
        Proposition[] props = new Proposition[b_kp1t.getFor().size()];
        int i = 0;
        for (RandomVariable rv : b_kp1t.getFor()) {
            RandomVariable prv = this.tToTm1StateVarMap.get(rv);
            props[i] = new RandVar(prv.getName(), prv.getDomain());
            ++i;
        }
        final Proposition Xk = ProbUtil.constructConjunction(props);
        Proposition[] ax_kp1 = new AssignmentProposition[this.tToTm1StateVarMap.size()];
        final HashMap<RandomVariable, Proposition> x_kp1VarAssignMap = new HashMap<RandomVariable, Proposition>();
        i = 0;
        for (RandomVariable rv : b_kp1t.getFor()) {
            ax_kp1[i] = new AssignmentProposition(rv, "<Dummy Value>");
            x_kp1VarAssignMap.put(rv, ax_kp1[i]);
            ++i;
        }
        final Proposition x_kp1 = ProbUtil.constructConjunction(ax_kp1);
        props = new Proposition[e_kp1.size()];
        final Proposition pe_kp1 = ProbUtil.constructConjunction(e_kp1.toArray(props));
        CategoricalDistribution.Iterator ib_kp2t = new CategoricalDistribution.Iterator(){

            @Override
            public void iterate(Map<RandomVariable, Object> possibleWorld, double probability) {
                for (Map.Entry<RandomVariable, Object> av : possibleWorld.entrySet()) {
                    ((AssignmentProposition)x_kp1VarAssignMap.get(av.getKey())).setValue(av.getValue());
                }
                double p = ForwardBackward.this.sensorModel.posterior(pe_kp1, x_kp1) * probability;
                int i = 0;
                for (double tp : ForwardBackward.this.transitionModel.posteriorDistribution(x_kp1, Xk).getValues()) {
                    b_kp1t.setValue(i, b_kp1t.getValues()[i] + tp * p);
                    ++i;
                }
            }
        };
        b_kp2t.iterateOver(ib_kp2t);
        return b_kp1t;
    }

    private CategoricalDistribution initBackwardMessage() {
        ProbabilityTable b = new ProbabilityTable(this.tToTm1StateVarMap.keySet());
        for (int i = 0; i < b.size(); ++i) {
            b.setValue(i, 1.0);
        }
        return b;
    }
}

