/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.proposition;

import aima.core.probability.RandomVariable;
import aima.core.probability.domain.FiniteDomain;
import aima.core.probability.proposition.AbstractDerivedProposition;
import java.util.Map;

public class SubsetProposition
extends AbstractDerivedProposition {
    private FiniteDomain subsetDomain = null;
    private RandomVariable varSubsetOf = null;
    private String toString = null;

    public SubsetProposition(String name, FiniteDomain subsetDomain, RandomVariable ofVar) {
        super(name);
        if (null == subsetDomain) {
            throw new IllegalArgumentException("Sum Domain must be specified.");
        }
        this.subsetDomain = subsetDomain;
        this.varSubsetOf = ofVar;
        this.addScope(this.varSubsetOf);
    }

    @Override
    public boolean holds(Map<RandomVariable, Object> possibleWorld) {
        return this.subsetDomain.getPossibleValues().contains(possibleWorld.get(this.varSubsetOf));
    }

    public String toString() {
        if (null == this.toString) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getDerivedName());
            sb.append(" = ");
            sb.append(this.subsetDomain.toString());
            this.toString = sb.toString();
        }
        return this.toString;
    }
}

