/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.proposition;

import aima.core.probability.RandomVariable;
import aima.core.probability.domain.FiniteIntegerDomain;
import aima.core.probability.proposition.AbstractDerivedProposition;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IntegerSumProposition
extends AbstractDerivedProposition {
    private FiniteIntegerDomain sumsDomain = null;
    private List<RandomVariable> sumVars = new ArrayList<RandomVariable>();
    private String toString = null;

    public IntegerSumProposition(String name, FiniteIntegerDomain sumsDomain, RandomVariable ... sums) {
        super(name);
        if (null == sumsDomain) {
            throw new IllegalArgumentException("Sum Domain must be specified.");
        }
        if (null == sums || 0 == sums.length) {
            throw new IllegalArgumentException("Sum variables must be specified.");
        }
        this.sumsDomain = sumsDomain;
        for (RandomVariable rv : sums) {
            this.addScope(rv);
            this.sumVars.add(rv);
        }
    }

    @Override
    public boolean holds(Map<RandomVariable, Object> possibleWorld) {
        Integer sum = new Integer(0);
        for (RandomVariable rv : this.sumVars) {
            Object o = possibleWorld.get(rv);
            if (o instanceof Integer) {
                sum = sum + (Integer)o;
                continue;
            }
            throw new IllegalArgumentException("Possible World does not contain a Integer value for the sum variable:" + rv);
        }
        return this.sumsDomain.getPossibleValues().contains(sum);
    }

    public String toString() {
        if (null == this.toString) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getDerivedName());
            sb.append(" = ");
            sb.append(this.sumsDomain.toString());
            this.toString = sb.toString();
        }
        return this.toString;
    }
}

