/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.proposition;

import aima.core.probability.RandomVariable;
import aima.core.probability.proposition.AbstractDerivedProposition;
import java.util.Iterator;
import java.util.Map;

public class EquivalentProposition
extends AbstractDerivedProposition {
    private String toString = null;

    public EquivalentProposition(String name, RandomVariable ... equivs) {
        super(name);
        if (null == equivs || 1 >= equivs.length) {
            throw new IllegalArgumentException("Equivalent variables must be specified.");
        }
        for (RandomVariable rv : equivs) {
            this.addScope(rv);
        }
    }

    @Override
    public boolean holds(Map<RandomVariable, Object> possibleWorld) {
        boolean holds = true;
        Iterator<RandomVariable> i = this.getScope().iterator();
        RandomVariable rvL = i.next();
        while (i.hasNext()) {
            RandomVariable rvC = i.next();
            if (!possibleWorld.get(rvL).equals(possibleWorld.get(rvC))) {
                holds = false;
                break;
            }
            rvL = rvC;
        }
        return holds;
    }

    public String toString() {
        if (null == this.toString) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getDerivedName());
            for (RandomVariable rv : this.getScope()) {
                sb.append(" = ");
                sb.append(rv);
            }
            this.toString = sb.toString();
        }
        return this.toString;
    }
}

