/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.proposition;

import aima.core.probability.RandomVariable;
import aima.core.probability.proposition.AbstractProposition;
import aima.core.probability.proposition.BinarySentenceProposition;
import aima.core.probability.proposition.Proposition;
import java.util.Map;

public class DisjunctiveProposition
extends AbstractProposition
implements BinarySentenceProposition {
    private Proposition left = null;
    private Proposition right = null;
    private String toString = null;

    public DisjunctiveProposition(Proposition left, Proposition right) {
        if (null == left) {
            throw new IllegalArgumentException("Left side of disjunction must be specified.");
        }
        if (null == right) {
            throw new IllegalArgumentException("Right side of disjunction must be specified.");
        }
        this.addScope(left.getScope());
        this.addScope(right.getScope());
        this.addUnboundScope(left.getUnboundScope());
        this.addUnboundScope(right.getUnboundScope());
        this.left = left;
        this.right = right;
    }

    @Override
    public boolean holds(Map<RandomVariable, Object> possibleWorld) {
        return this.left.holds(possibleWorld) || this.right.holds(possibleWorld);
    }

    public String toString() {
        if (null == this.toString) {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(this.left.toString());
            sb.append(" OR ");
            sb.append(this.right.toString());
            sb.append(")");
            this.toString = sb.toString();
        }
        return this.toString;
    }
}

