/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.mdp.search;

import aima.core.agent.Action;
import aima.core.probability.mdp.MarkovDecisionProcess;
import aima.core.util.Util;
import java.util.Map;
import java.util.Set;

public class ValueIteration<S, A extends Action> {
    private double gamma = 0.0;

    public ValueIteration(double gamma) {
        if (gamma > 1.0 || gamma <= 0.0) {
            throw new IllegalArgumentException("Gamma must be > 0 and <= 1.0");
        }
        this.gamma = gamma;
    }

    public Map<S, Double> valueIteration(MarkovDecisionProcess<S, A> mdp, double epsilon) {
        Map<S, Double> U = Util.create(mdp.states(), new Double(0.0));
        Map<S, Double> Udelta = Util.create(mdp.states(), new Double(0.0));
        double delta = 0.0;
        double minDelta = epsilon * (1.0 - this.gamma) / this.gamma;
        do {
            U.putAll(Udelta);
            delta = 0.0;
            for (S s : mdp.states()) {
                Set<A> actions = mdp.actions(s);
                double aMax = 0.0;
                if (actions.size() > 0) {
                    aMax = Double.NEGATIVE_INFINITY;
                }
                for (Action a : actions) {
                    double aSum = 0.0;
                    for (S sDelta : mdp.states()) {
                        aSum += mdp.transitionProbability(sDelta, s, a) * U.get(sDelta);
                    }
                    if (!(aSum > aMax)) continue;
                    aMax = aSum;
                }
                Udelta.put(s, mdp.reward(s) + this.gamma * aMax);
                double aDiff = Math.abs(Udelta.get(s) - U.get(s));
                if (!(aDiff > delta)) continue;
                delta = aDiff;
            }
        } while (delta > minDelta);
        return U;
    }
}

