/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.mdp.impl;

import aima.core.agent.Action;
import aima.core.probability.mdp.MarkovDecisionProcess;
import aima.core.probability.mdp.PolicyEvaluation;
import java.util.HashMap;
import java.util.Map;

public class ModifiedPolicyEvaluation<S, A extends Action>
implements PolicyEvaluation<S, A> {
    private int k;
    private double gamma;

    public ModifiedPolicyEvaluation(int k, double gamma) {
        if (gamma > 1.0 || gamma <= 0.0) {
            throw new IllegalArgumentException("Gamma must be > 0 and <= 1.0");
        }
        this.k = k;
        this.gamma = gamma;
    }

    @Override
    public Map<S, Double> evaluate(Map<S, A> pi_i, Map<S, Double> U, MarkovDecisionProcess<S, A> mdp) {
        HashMap<S, Double> U_i = new HashMap<S, Double>(U);
        HashMap<S, Double> U_ip1 = new HashMap<S, Double>(U);
        for (int i = 0; i < this.k; ++i) {
            for (S s : U.keySet()) {
                Action ap_i = (Action)pi_i.get(s);
                double aSum = 0.0;
                if (null != ap_i) {
                    for (S sDelta : U.keySet()) {
                        aSum += mdp.transitionProbability(sDelta, s, ap_i) * (Double)U_i.get(sDelta);
                    }
                }
                U_ip1.put(s, mdp.reward(s) + this.gamma * aSum);
            }
            U_i.putAll(U_ip1);
        }
        return U_ip1;
    }
}

