/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.hmm.impl;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.RandomVariable;
import aima.core.probability.domain.FiniteDomain;
import aima.core.probability.hmm.HiddenMarkovModel;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.probability.util.ProbabilityTable;
import aima.core.util.Util;
import aima.core.util.math.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class HMM
implements HiddenMarkovModel {
    private RandomVariable stateVariable = null;
    private FiniteDomain stateVariableDomain = null;
    private Matrix transitionModel = null;
    private Map<Object, Matrix> sensorModel = null;
    private Matrix prior = null;

    public HMM(RandomVariable stateVariable, Matrix transitionModel, Map<Object, Matrix> sensorModel, Matrix prior) {
        if (!stateVariable.getDomain().isFinite()) {
            throw new IllegalArgumentException("State Variable for HHM must be finite.");
        }
        this.stateVariable = stateVariable;
        this.stateVariableDomain = (FiniteDomain)stateVariable.getDomain();
        if (transitionModel.getRowDimension() != transitionModel.getColumnDimension()) {
            throw new IllegalArgumentException("Transition Model row and column dimensions must match.");
        }
        if (this.stateVariableDomain.size() != transitionModel.getRowDimension()) {
            throw new IllegalArgumentException("Transition Model Matrix does not map correctly to the HMM's State Variable.");
        }
        this.transitionModel = transitionModel;
        for (Matrix smVal : sensorModel.values()) {
            if (smVal.getRowDimension() != smVal.getColumnDimension()) {
                throw new IllegalArgumentException("Sensor Model row and column dimensions must match.");
            }
            if (this.stateVariableDomain.size() == smVal.getRowDimension()) continue;
            throw new IllegalArgumentException("Sensor Model Matrix does not map correctly to the HMM's State Variable.");
        }
        this.sensorModel = sensorModel;
        if (transitionModel.getRowDimension() != prior.getRowDimension() && prior.getColumnDimension() != 1) {
            throw new IllegalArgumentException("Prior is not of the correct dimensions.");
        }
        this.prior = prior;
    }

    @Override
    public RandomVariable getStateVariable() {
        return this.stateVariable;
    }

    @Override
    public Matrix getTransitionModel() {
        return this.transitionModel;
    }

    @Override
    public Map<Object, Matrix> getSensorModel() {
        return this.sensorModel;
    }

    @Override
    public Matrix getPrior() {
        return this.prior;
    }

    @Override
    public Matrix getEvidence(List<AssignmentProposition> evidence) {
        if (evidence.size() != 1) {
            throw new IllegalArgumentException("Only a single evidence observation value should be provided.");
        }
        Matrix e = this.sensorModel.get(evidence.get(0).getValue());
        if (null == e) {
            throw new IllegalArgumentException("Evidence does not map to sensor model.");
        }
        return e;
    }

    @Override
    public Matrix createUnitMessage() {
        double[] values = new double[this.stateVariableDomain.size()];
        Arrays.fill(values, 1.0);
        return new Matrix(values, values.length);
    }

    @Override
    public Matrix convert(CategoricalDistribution fromCD) {
        double[] values = fromCD.getValues();
        return new Matrix(values, values.length);
    }

    @Override
    public CategoricalDistribution convert(Matrix fromMessage) {
        return new ProbabilityTable(fromMessage.getRowPackedCopy(), this.stateVariable);
    }

    @Override
    public List<CategoricalDistribution> convert(List<Matrix> matrixs) {
        ArrayList<CategoricalDistribution> cds = new ArrayList<CategoricalDistribution>();
        for (Matrix m : matrixs) {
            cds.add(this.convert(m));
        }
        return cds;
    }

    @Override
    public Matrix normalize(Matrix m) {
        double[] values = m.getRowPackedCopy();
        return new Matrix(Util.normalize(values), values.length);
    }
}

