/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.hmm.exact;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.hmm.HiddenMarkovModel;
import aima.core.probability.hmm.exact.HMMForwardBackward;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.util.math.Matrix;
import java.util.ArrayList;
import java.util.List;

public class HMMForwardBackwardConstantSpace
extends HMMForwardBackward {
    public HMMForwardBackwardConstantSpace(HiddenMarkovModel hmm) {
        super(hmm);
    }

    @Override
    public List<CategoricalDistribution> forwardBackward(List<List<AssignmentProposition>> ev, CategoricalDistribution prior) {
        int i;
        Matrix f = this.hmm.convert(prior);
        Matrix b = this.hmm.createUnitMessage();
        ArrayList<Matrix> sv = new ArrayList<Matrix>(ev.size());
        for (i = 0; i < ev.size(); ++i) {
            f = this.forward(f, this.hmm.getEvidence(ev.get(i)));
        }
        for (i = ev.size() - 1; i >= 0; --i) {
            sv.add(0, this.hmm.normalize(f.arrayTimes(b)));
            Matrix e = this.hmm.getEvidence(ev.get(i));
            b = this.backward(b, e);
            f = this.forwardRecover(e, f);
        }
        return this.hmm.convert(sv);
    }

    public Matrix forwardRecover(Matrix O_tp1, Matrix f1_tp1) {
        return this.hmm.normalize(this.hmm.getTransitionModel().transpose().inverse().times(O_tp1.inverse()).times(f1_tp1));
    }
}

