/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.hmm.exact;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.hmm.HiddenMarkovModel;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.probability.temporal.ForwardBackwardInference;
import aima.core.util.math.Matrix;
import java.util.ArrayList;
import java.util.List;

public class HMMForwardBackward
implements ForwardBackwardInference {
    protected HiddenMarkovModel hmm = null;

    public HMMForwardBackward(HiddenMarkovModel hmm) {
        this.hmm = hmm;
    }

    @Override
    public List<CategoricalDistribution> forwardBackward(List<List<AssignmentProposition>> ev, CategoricalDistribution prior) {
        int i;
        ArrayList<Matrix> fv = new ArrayList<Matrix>(ev.size() + 1);
        Matrix b = this.hmm.createUnitMessage();
        ArrayList<Matrix> sv = new ArrayList<Matrix>(ev.size());
        fv.add(this.hmm.convert(prior));
        for (i = 0; i < ev.size(); ++i) {
            fv.add(this.forward((Matrix)fv.get(i), this.hmm.getEvidence(ev.get(i))));
        }
        for (i = ev.size() - 1; i >= 0; --i) {
            sv.add(0, this.hmm.normalize(((Matrix)fv.get(i + 1)).arrayTimes(b)));
            b = this.backward(b, this.hmm.getEvidence(ev.get(i)));
        }
        return this.hmm.convert(sv);
    }

    @Override
    public CategoricalDistribution forward(CategoricalDistribution f1_t, List<AssignmentProposition> e_tp1) {
        return this.hmm.convert(this.forward(this.hmm.convert(f1_t), this.hmm.getEvidence(e_tp1)));
    }

    @Override
    public CategoricalDistribution backward(CategoricalDistribution b_kp2t, List<AssignmentProposition> e_kp1) {
        return this.hmm.convert(this.backward(this.hmm.convert(b_kp2t), this.hmm.getEvidence(e_kp1)));
    }

    public Matrix forward(Matrix f1_t, Matrix O_tp1) {
        return this.hmm.normalize(O_tp1.times(this.hmm.getTransitionModel().transpose().times(f1_t)));
    }

    public Matrix backward(Matrix b_kp2t, Matrix O_kp1) {
        return this.hmm.getTransitionModel().times(O_kp1).times(b_kp2t);
    }
}

