/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.hmm.exact;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.hmm.HiddenMarkovModel;
import aima.core.probability.proposition.AssignmentProposition;
import aima.core.util.math.Matrix;
import java.util.LinkedList;
import java.util.List;

public class FixedLagSmoothing {
    private int t = 1;
    private Matrix f = null;
    private Matrix B = null;
    private List<Matrix> e_tmd_to_t = new LinkedList<Matrix>();
    private HiddenMarkovModel hmm = null;
    private int d = 1;
    private Matrix unitMessage = null;

    public FixedLagSmoothing(HiddenMarkovModel hmm, int d) {
        this.hmm = hmm;
        this.d = d;
        this.initPersistent();
    }

    public CategoricalDistribution fixedLagSmoothing(List<AssignmentProposition> et) {
        this.e_tmd_to_t.add(this.hmm.getEvidence(et));
        Matrix O_t = this.e_tmd_to_t.get(this.e_tmd_to_t.size() - 1);
        if (this.t > this.d) {
            this.e_tmd_to_t.remove(0);
            Matrix O_tmd = this.e_tmd_to_t.get(0);
            this.f = this.forward(this.f, O_tmd);
            this.B = O_tmd.inverse().times(this.hmm.getTransitionModel().inverse()).times(this.B).times(this.hmm.getTransitionModel()).times(O_t);
        } else {
            this.B = this.B.times(this.hmm.getTransitionModel()).times(O_t);
        }
        CategoricalDistribution rVal = null;
        if (this.t > this.d) {
            rVal = this.hmm.convert(this.hmm.normalize(this.f.arrayTimes(this.B.times(this.unitMessage))));
        }
        ++this.t;
        return rVal;
    }

    public Matrix forward(Matrix f1_t, Matrix O_tp1) {
        return this.hmm.normalize(O_tp1.times(this.hmm.getTransitionModel().transpose().times(f1_t)));
    }

    private void initPersistent() {
        this.t = 1;
        this.f = this.hmm.getPrior();
        this.B = Matrix.identity(this.f.getRowDimension(), this.f.getRowDimension());
        this.e_tmd_to_t.clear();
        this.unitMessage = this.hmm.createUnitMessage();
    }
}

