/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.full;

import aima.core.probability.CategoricalDistribution;
import aima.core.probability.FiniteProbabilityModel;
import aima.core.probability.RandomVariable;
import aima.core.probability.proposition.ConjunctiveProposition;
import aima.core.probability.proposition.Proposition;
import aima.core.probability.util.ProbUtil;
import aima.core.probability.util.ProbabilityTable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class FullJointDistributionModel
implements FiniteProbabilityModel {
    private ProbabilityTable distribution = null;
    private Set<RandomVariable> representation = null;

    public FullJointDistributionModel(double[] values, RandomVariable ... vars) {
        if (null == vars) {
            throw new IllegalArgumentException("Random Variables describing the model's representation of the World need to be specified.");
        }
        this.distribution = new ProbabilityTable(values, vars);
        this.representation = new LinkedHashSet<RandomVariable>();
        for (int i = 0; i < vars.length; ++i) {
            this.representation.add(vars[i]);
        }
        this.representation = Collections.unmodifiableSet(this.representation);
    }

    @Override
    public boolean isValid() {
        return Math.abs(1.0 - this.distribution.getSum()) <= 1.0E-8;
    }

    @Override
    public double prior(Proposition ... phi) {
        return this.probabilityOf(ProbUtil.constructConjunction(phi));
    }

    @Override
    public double posterior(Proposition phi, Proposition ... evidence) {
        Proposition conjEvidence = ProbUtil.constructConjunction(evidence);
        ConjunctiveProposition aAndB = new ConjunctiveProposition(phi, conjEvidence);
        double probabilityOfEvidence = this.prior(conjEvidence);
        if (0.0 != probabilityOfEvidence) {
            return this.prior(aAndB) / probabilityOfEvidence;
        }
        return 0.0;
    }

    @Override
    public Set<RandomVariable> getRepresentation() {
        return this.representation;
    }

    @Override
    public CategoricalDistribution priorDistribution(Proposition ... phi) {
        return this.jointDistribution(phi);
    }

    @Override
    public CategoricalDistribution posteriorDistribution(Proposition phi, Proposition ... evidence) {
        Proposition conjEvidence = ProbUtil.constructConjunction(evidence);
        CategoricalDistribution dAandB = this.jointDistribution(phi, conjEvidence);
        CategoricalDistribution dEvidence = this.jointDistribution(conjEvidence);
        return dAandB.divideBy(dEvidence);
    }

    @Override
    public CategoricalDistribution jointDistribution(Proposition ... propositions) {
        ProbabilityTable d = null;
        final Proposition conjProp = ProbUtil.constructConjunction(propositions);
        final LinkedHashSet<RandomVariable> vars = new LinkedHashSet<RandomVariable>(conjProp.getUnboundScope());
        if (vars.size() > 0) {
            RandomVariable[] distVars = new RandomVariable[vars.size()];
            vars.toArray(distVars);
            final ProbabilityTable ud = new ProbabilityTable(distVars);
            final Object[] values = new Object[vars.size()];
            ProbabilityTable.Iterator di = new ProbabilityTable.Iterator(){

                @Override
                public void iterate(Map<RandomVariable, Object> possibleWorld, double probability) {
                    if (conjProp.holds(possibleWorld)) {
                        int i = 0;
                        for (RandomVariable rv : vars) {
                            values[i] = possibleWorld.get(rv);
                            ++i;
                        }
                        int dIdx = ud.getIndex(values);
                        ud.setValue(dIdx, ud.getValues()[dIdx] + probability);
                    }
                }
            };
            this.distribution.iterateOverTable(di);
            d = ud;
        } else {
            d = new ProbabilityTable(new RandomVariable[0]);
            d.setValue(0, this.prior(propositions));
        }
        return d;
    }

    private double probabilityOf(final Proposition phi) {
        final double[] probSum = new double[1];
        ProbabilityTable.Iterator di = new ProbabilityTable.Iterator(){

            @Override
            public void iterate(Map<RandomVariable, Object> possibleWorld, double probability) {
                if (phi.holds(possibleWorld)) {
                    probSum[0] = probSum[0] + probability;
                }
            }
        };
        this.distribution.iterateOverTable(di);
        return probSum[0];
    }
}

