/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.example;

import aima.core.environment.cellworld.Cell;
import aima.core.environment.cellworld.CellWorld;
import aima.core.environment.cellworld.CellWorldAction;
import aima.core.probability.mdp.ActionsFunction;
import aima.core.probability.mdp.MarkovDecisionProcess;
import aima.core.probability.mdp.RewardFunction;
import aima.core.probability.mdp.TransitionProbabilityFunction;
import aima.core.probability.mdp.impl.MDP;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MDPFactory {
    public static MarkovDecisionProcess<Cell<Double>, CellWorldAction> createMDPForFigure17_3(CellWorld<Double> cw) {
        return new MDP<Cell<Double>, CellWorldAction>(cw.getCells(), cw.getCellAt(1, 1), MDPFactory.createActionsFunctionForFigure17_1(cw), MDPFactory.createTransitionProbabilityFunctionForFigure17_1(cw), MDPFactory.createRewardFunctionForFigure17_1());
    }

    public static ActionsFunction<Cell<Double>, CellWorldAction> createActionsFunctionForFigure17_1(CellWorld<Double> cw) {
        final HashSet<Cell<Double>> terminals = new HashSet<Cell<Double>>();
        terminals.add(cw.getCellAt(4, 3));
        terminals.add(cw.getCellAt(4, 2));
        ActionsFunction<Cell<Double>, CellWorldAction> af = new ActionsFunction<Cell<Double>, CellWorldAction>(){

            @Override
            public Set<CellWorldAction> actions(Cell<Double> s) {
                if (terminals.contains(s)) {
                    return Collections.emptySet();
                }
                return CellWorldAction.actions();
            }
        };
        return af;
    }

    public static TransitionProbabilityFunction<Cell<Double>, CellWorldAction> createTransitionProbabilityFunctionForFigure17_1(final CellWorld<Double> cw) {
        TransitionProbabilityFunction<Cell<Double>, CellWorldAction> tf = new TransitionProbabilityFunction<Cell<Double>, CellWorldAction>(){
            private double[] distribution = new double[]{0.8, 0.1, 0.1};

            @Override
            public double probability(Cell<Double> sDelta, Cell<Double> s, CellWorldAction a) {
                double prob = 0.0;
                List<Cell<Double>> outcomes = this.possibleOutcomes(s, a);
                for (int i = 0; i < outcomes.size(); ++i) {
                    if (!sDelta.equals(outcomes.get(i))) continue;
                    prob += this.distribution[i];
                }
                return prob;
            }

            private List<Cell<Double>> possibleOutcomes(Cell<Double> c, CellWorldAction a) {
                ArrayList<Cell<Double>> outcomes = new ArrayList<Cell<Double>>();
                outcomes.add(cw.result(c, a));
                outcomes.add(cw.result(c, a.getFirstRightAngledAction()));
                outcomes.add(cw.result(c, a.getSecondRightAngledAction()));
                return outcomes;
            }
        };
        return tf;
    }

    public static RewardFunction<Cell<Double>> createRewardFunctionForFigure17_1() {
        RewardFunction<Cell<Double>> rf = new RewardFunction<Cell<Double>>(){

            @Override
            public double reward(Cell<Double> s) {
                return s.getContent();
            }
        };
        return rf;
    }
}

