/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.example;

import aima.core.probability.FiniteProbabilityModel;
import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.impl.BayesNet;
import aima.core.probability.bayes.impl.FullCPTNode;
import aima.core.probability.bayes.model.FiniteBayesModel;
import aima.core.probability.example.ExampleRV;
import java.util.HashMap;
import java.util.Map;

public class GenericTemporalModelFactory {
    public static FiniteProbabilityModel getUmbrellaWorldTransitionModel() {
        return GenericTemporalModelFactory.getUmbrellaWorldModel();
    }

    public static FiniteProbabilityModel getUmbrellaWorldSensorModel() {
        return GenericTemporalModelFactory.getUmbrellaWorldModel();
    }

    public static FiniteProbabilityModel getUmbrellaWorldModel() {
        FullCPTNode rain_tm1 = new FullCPTNode((RandomVariable)ExampleRV.RAIN_tm1_RV, new double[]{0.5, 0.5});
        FullCPTNode rain_t = new FullCPTNode((RandomVariable)ExampleRV.RAIN_t_RV, new double[]{0.7, 0.3, 0.3, 0.7}, rain_tm1);
        FullCPTNode umbrealla_t = new FullCPTNode((RandomVariable)ExampleRV.UMBREALLA_t_RV, new double[]{0.9, 0.1, 0.2, 0.8}, rain_t);
        return new FiniteBayesModel(new BayesNet(rain_tm1));
    }

    public static Map<RandomVariable, RandomVariable> getUmbrellaWorld_Xt_to_Xtm1_Map() {
        HashMap<RandomVariable, RandomVariable> tToTm1StateVarMap = new HashMap<RandomVariable, RandomVariable>();
        tToTm1StateVarMap.put(ExampleRV.RAIN_t_RV, ExampleRV.RAIN_tm1_RV);
        return tToTm1StateVarMap;
    }
}

