/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.example;

import aima.core.probability.RandomVariable;
import aima.core.probability.bayes.BayesianNetwork;
import aima.core.probability.bayes.impl.BayesNet;
import aima.core.probability.bayes.impl.FullCPTNode;
import aima.core.probability.example.ExampleRV;

public class BayesNetExampleFactory {
    public static BayesianNetwork construct2FairDiceNetwor() {
        FullCPTNode dice1 = new FullCPTNode((RandomVariable)ExampleRV.DICE_1_RV, new double[]{0.16666666666666666, 0.16666666666666666, 0.16666666666666666, 0.16666666666666666, 0.16666666666666666, 0.16666666666666666});
        FullCPTNode dice2 = new FullCPTNode((RandomVariable)ExampleRV.DICE_2_RV, new double[]{0.16666666666666666, 0.16666666666666666, 0.16666666666666666, 0.16666666666666666, 0.16666666666666666, 0.16666666666666666});
        return new BayesNet(dice1, dice2);
    }

    public static BayesianNetwork constructToothacheCavityCatchNetwork() {
        FullCPTNode cavity = new FullCPTNode((RandomVariable)ExampleRV.CAVITY_RV, new double[]{0.2, 0.8});
        FullCPTNode toothache = new FullCPTNode((RandomVariable)ExampleRV.TOOTHACHE_RV, new double[]{0.6, 0.4, 0.1, 0.9}, cavity);
        FullCPTNode catchN = new FullCPTNode((RandomVariable)ExampleRV.CATCH_RV, new double[]{0.9, 0.1, 0.2, 0.8}, cavity);
        return new BayesNet(cavity);
    }

    public static BayesianNetwork constructToothacheCavityCatchWeatherNetwork() {
        FullCPTNode cavity = new FullCPTNode((RandomVariable)ExampleRV.CAVITY_RV, new double[]{0.2, 0.8});
        FullCPTNode toothache = new FullCPTNode((RandomVariable)ExampleRV.TOOTHACHE_RV, new double[]{0.6, 0.4, 0.1, 0.9}, cavity);
        FullCPTNode catchN = new FullCPTNode((RandomVariable)ExampleRV.CATCH_RV, new double[]{0.9, 0.1, 0.2, 0.8}, cavity);
        FullCPTNode weather = new FullCPTNode((RandomVariable)ExampleRV.WEATHER_RV, new double[]{0.6, 0.1, 0.29, 0.01});
        return new BayesNet(cavity, weather);
    }

    public static BayesianNetwork constructMeningitisStiffNeckNetwork() {
        FullCPTNode meningitis = new FullCPTNode((RandomVariable)ExampleRV.MENINGITIS_RV, new double[]{2.0E-5, 0.99998});
        FullCPTNode stiffneck = new FullCPTNode((RandomVariable)ExampleRV.STIFF_NECK_RV, new double[]{0.7, 0.3, 0.009986199723994478, 0.9900138002760055}, meningitis);
        return new BayesNet(meningitis);
    }

    public static BayesianNetwork constructBurglaryAlarmNetwork() {
        FullCPTNode burglary = new FullCPTNode((RandomVariable)ExampleRV.BURGLARY_RV, new double[]{0.001, 0.999});
        FullCPTNode earthquake = new FullCPTNode((RandomVariable)ExampleRV.EARTHQUAKE_RV, new double[]{0.002, 0.998});
        FullCPTNode alarm = new FullCPTNode((RandomVariable)ExampleRV.ALARM_RV, new double[]{0.95, 0.05, 0.94, 0.06, 0.29, 0.71, 0.001, 0.999}, burglary, earthquake);
        FullCPTNode johnCalls = new FullCPTNode((RandomVariable)ExampleRV.JOHN_CALLS_RV, new double[]{0.9, 0.1, 0.05, 0.95}, alarm);
        FullCPTNode maryCalls = new FullCPTNode((RandomVariable)ExampleRV.MARY_CALLS_RV, new double[]{0.7, 0.3, 0.01, 0.99}, alarm);
        return new BayesNet(burglary, earthquake);
    }

    public static BayesianNetwork constructCloudySprinklerRainWetGrassNetwork() {
        FullCPTNode cloudy = new FullCPTNode((RandomVariable)ExampleRV.CLOUDY_RV, new double[]{0.5, 0.5});
        FullCPTNode sprinkler = new FullCPTNode((RandomVariable)ExampleRV.SPRINKLER_RV, new double[]{0.1, 0.9, 0.5, 0.5}, cloudy);
        FullCPTNode rain = new FullCPTNode((RandomVariable)ExampleRV.RAIN_RV, new double[]{0.8, 0.2, 0.2, 0.8}, cloudy);
        FullCPTNode wetGrass = new FullCPTNode((RandomVariable)ExampleRV.WET_GRASS_RV, new double[]{0.99, 0.01, 0.9, 0.1, 0.9, 0.1, 0.0, 1.0}, sprinkler, rain);
        return new BayesNet(cloudy);
    }
}

