/*
 * Decompiled with CFR 0.152.
 */
package aima.core.probability.domain;

import aima.core.probability.domain.FiniteDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFiniteDomain
implements FiniteDomain {
    private String toString = null;
    private Map<Object, Integer> valueToIdx = new HashMap<Object, Integer>();
    private Map<Integer, Object> idxToValue = new HashMap<Integer, Object>();

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public abstract int size();

    @Override
    public abstract boolean isOrdered();

    @Override
    public abstract Set<? extends Object> getPossibleValues();

    @Override
    public int getOffset(Object value) {
        Integer idx = this.valueToIdx.get(value);
        if (null == idx) {
            throw new IllegalArgumentException("Value [" + value + "] is not a possible value of this domain.");
        }
        return idx;
    }

    @Override
    public Object getValueAt(int offset) {
        return this.idxToValue.get(offset);
    }

    public String toString() {
        if (null == this.toString) {
            this.toString = this.getPossibleValues().toString();
        }
        return this.toString;
    }

    protected void indexPossibleValues(Set<? extends Object> possibleValues) {
        int idx = 0;
        for (Object object : possibleValues) {
            this.valueToIdx.put(object, idx);
            this.idxToValue.put(idx, object);
            ++idx;
        }
    }
}

